/*
 * ===========================================================================
 * (c) Copyright IBM Corp. 2019, 2022 All Rights Reserved
 * ===========================================================================
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * IBM designates this particular file as subject to the "Classpath" exception
 * as provided by IBM in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, see <http://www.gnu.org/licenses/>.
 *
 * ===========================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <dlfcn.h>
#include "NativeCrypto_md.h"

/* Load the crypto library (return NULL on error) */
void * load_crypto_library(jboolean traceEnabled) {
    void * result = NULL;
    
    const char *libname = "libcrypto.1.1.dylib";
    const char *oldname = "libcrypto.1.0.0.dylib";
    const char *symlink = "libcrypto.dylib";

    result = dlopen (libname,  RTLD_NOW);
    if (result == NULL) {
        result = dlopen (oldname,  RTLD_NOW);
        if (result == NULL) {
            result = dlopen (symlink,  RTLD_NOW);
        }
    }

    return result;
}

/* Unload the crypto library */
void unload_crypto_library(void *handle) {
    (void)dlclose(handle);
}

/* Find the symbol in the crypto library (return NULL if not found) */
void * find_crypto_symbol(void *handle, const char *symname) {
    return  dlsym(handle, symname);
}

/* Find the path that the library was loaded from */
void get_library_path(void * handle, char * library_path) {
    Dl_info info;
    // Load binary path information from dlinfo() API if available, 
    // else return "Unknown path" 
    if (dladdr(handle, &info)) {
        strcpy(library_path, info.dli_fname);
    } else {
        strcpy(library_path, "Unknown path");
    }
}
