/*
 * ===========================================================================
 * (c) Copyright IBM Corp. 2019, 2022 All Rights Reserved
 * ===========================================================================
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * IBM designates this particular file as subject to the "Classpath" exception
 * as provided by IBM in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, see <http://www.gnu.org/licenses/>.
 *
 * ===========================================================================
 */

#ifndef NATIVECRYPTO_MD_H
#define NATIVECRYPTO_MD_H

#include <jni.h>

void * load_crypto_library(jboolean traceEnabled);
void   unload_crypto_library(void *handle);
void * find_crypto_symbol(void *handle, const char *symname);
void   get_library_path(void * handle, char * library_path);

#endif /* NATIVECRYPTO_MD_H */
