<!--
* Copyright (c) 2017, 2021 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] http://openjdk.java.net/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH
* Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
-->

# Eclipse OpenJ9 version 0.10.0 release notes

These release notes support the [Eclipse OpenJ9 0.10.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.10.0/plan).



## Binaries and supported environments

This release adds compatibility with OpenJDK v11. Builds of OpenJDK 11 with OpenJ9 are available from the AdoptOpenJDK community at the following link:

- [OpenJDK version 11](https://adoptopenjdk.net/archive.html?variant=openjdk11&jvmVariant=openj9)

Builds are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK. Builds are compatible with OpenJDK 11. Compliance with the specification is tracked at the AdoptOpenJDK website where compliant builds are marked with a blue check mark.

OpenJDK 11 with Eclipse OpenJ9 is a long term support (LTS) release and supersedes OpenJDK 10 with Eclipse OpenJ9.

Although it is possible to build an OpenJDK v8 with the OpenJ9 0.10.0 release level, testing at the project is not complete and therefore support is not available.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).


## Notable changes in this release

The following table covers notable changes in v0.10.0. Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.10/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/2108">#2108</a></td>
<td valign="top">JEP 181 Nest-Based Access Control</td>
<td valign="top">OpenJDK11</td>
<td valign="top">Implementing OpenJDK 11 <a href="http://openjdk.java.net/jeps/181">JEP 181</a>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/954">#954</a></td>
<td valign="top">JEP 309 Dynamic Class-File Constants</td>
<td valign="top">OpenJDK11</td>
<td valign="top">Implementing OpenJDK 11 <a href="http://openjdk.java.net/jeps/309">JEP 309</a>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/992">#992</a></td>
<td valign="top">JEP 320 Remove the Java EE and CORBA Modules</td>
<td valign="top">OpenJDK11</td>
<td valign="top">Implementing OpenJDK 11 <a href="http://openjdk.java.net/jeps/320">JEP 320</a>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/1875">#1875</a></td>
<td valign="top">JEP 327 Unicode 10</td>
<td valign="top">OpenJDK11</td>
<td valign="top">Implementing OpenJDK 11 <a href="http://openjdk.java.net/jeps/327">JEP 327</a>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/2576">#2576</a></td>
<td valign="top">Performance improvements for VM entry/exit for JNI natives</td>
<td valign="top">OpenJDK8 and later: All platforms</td>
<td valign="top">Atomic compare-and-swap operations are replaced with
a modified Dekker algorithm, which provides a lightweight mechanism
for synchronizing VM entry and exit for JNI native code.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/1938">#1938</a></td>
<td valign="top">The default shared classes cache size is increased.</td>
<td valign="top">OpenJDK8: 64-bit platforms</td>
<td valign="top">The default size is increased from 16 MB to 300 MB, with a "soft" maximum limit for the initial size of the cache (-Xscmx) set to 64 MB.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/2746">#2746</a></td>
<td valign="top">Java dump files now record the value for the soft maximum shared cache size (`-Xscmx`).</td>
<td valign="top">OpenJDK8 and later: All platforms</td>
<td valign="top">The value for `-Xscmx` is recorded in the `SHARED CLASSES` section of the Java dump file against the string `2SCLTEXTSMB`. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/2508">#2508</a></td>
<td valign="top">New OpenJ9 option, <code>-XX:HeapDumpPath</code>.</td>
<td valign="top">OpenJDK8 and later: All platforms</td>
<td valign="top">For compatibility with HotSpot, <code>-XX:HeapDumpPath</code> is accepted by OpenJ9, which has the same functionality as <code>-Xdump:directory</code>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/2533">#2533</a></td>
<td valign="top">New OpenJ9 option, <code>-XX:[+|-]HeapDumpOnOutOfMemoryError</code>.</td>
<td valign="top">OpenJDK8 and later: All platforms</td>
<td valign="top">For compatibility with HotSpot, <code>-XX:[+|-]HeapDumpOnOutOfMemoryError</code> is accepted by OpenJ9, which can enable or disable dumps when an OutOfMemory exception occurs.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/2196">#2196</a></td>
<td valign="top">New OpenJ9 option, <code>-XX:ActiveProcessorCount=<value></code>.</td>
<td valign="top">OpenJDK8 and later: All platforms</td>
<td valign="top">For compatibility with HotSpot, this option overrides the value for the number of CPUs that are automatically detected by the JVM. Additional Java dump information is recorded when the option is set.</td>
</tr>

</table>


## Known Issues

The v0.10.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/378">#378</a></td>
<td valign="top">DDR support</td>
<td valign="top">AIX</td>
<td valign="top">Inability to diagnose problems with the VM, garbage collector, or JIT.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/54">#54</a></td>
<td valign="top">Signal handling</td>
<td valign="top">All platforms</td>
<td valign="top">Currently, shutdown signals (<code>SIGINT</code>, <code>SIGHUP</code> and <code>SIGTERM</code>) and <code>SIGCONT</code> are fully supported on Unix platforms (pLinux, zLinux, xLinux, AIX, and z/OS). Support for other POSIX signals is pending. See <code>SunMiscSignalTest.java</code> for the list of signals that need to be supported.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/479">#479</a></td>
<td valign="top">Non-compressed references VM builds not available</td>
<td valign="top">AIX, Windows, Linux on Z, Linux on Power</td>
<td valign="top">Non-compressed references VM builds, which support heaps larger than 57GB, are built on Linux on x86. </td>
<td valign="top">Manual builds on other platforms are possible by following our <a href="https://github.com/eclipse-openj9/openj9/blob/master/buildenv/Build_Instructions_V8.md">detailed build instructions</a>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/897">#897</a></td>
<td valign="top">Javadoc not building some OpenJ9 extensions.</td>
<td valign="top">All platforms</td>
<td valign="top">Some API documentation is missing in the <code>build/&lt;platform&gt;/docs</code> directory.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/898">#898</a></td>
<td valign="top">Javadoc building some unsupported OpenJ9 extensions.</td>
<td valign="top">All platforms</td>
<td valign="top">Some API documentation in <code>build/&lt;platform&gt;/docs</code> is not supported with OpenJ9.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/ibmruntimes/openj9-openjdk-jdk8/issues/17">#17</a></td>
<td valign="top">OpenJDK with OpenJ9 builds before Java 11 contain extra shared libraries.</td>
<td valign="top">All platforms</td>
<td valign="top">Shared libraries must not be used in production.</td>
<td valign="top">None</td>
</tr>
</tbody>
</table>

## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.10.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.10.0).
