<!--
* Copyright (c) 2019, 2021 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] http://openjdk.java.net/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH
* Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
-->

# Eclipse OpenJ9 version 0.16 release notes

These release notes support the [Eclipse OpenJ9 0.16 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.16/plan).

## Binaries and supported environments

OpenJ9 release 0.16 supports OpenJDK 13.

Binaries are available at the AdoptOpenJDK project:

- [OpenJDK 13 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk13&jvmVariant=openj9)

All builds are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).


## Notable changes in this release

The following table covers notable changes in v0.16. Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.16/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>


<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/6271">#6271</a></td>
<td valign="top">Class data sharing for bootstrap classes is enabled by default</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">Class data sharing is enabled by default for bootstrap classes, unless your application is running in a container. You can use the <tt>-Xshareclasses</tt> option to change the default behavior.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/6541">#6541</a></td>
<td valign="top">New option to share VM anonymous classes in the shared classes cache</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">Anonymous classes (defined by <tt>Unsafe.defineAnonymousClass</tt>) are now stored in the shared classes cache by default so that they are available for ahead-of-time (AOT) compilation. To
prevent these classes being shared, use the <tt>-XX:-ShareAnonymousClasses</tt> option.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/6536">#6536</a>, <a href="https://github.com/eclipse-openj9/openj9/pull/5480">#5480</a></td>
<td valign="top">Changes to the shared classes cache generation number</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">The format of classes that are stored in the shared classes cache is changed. To save space, all existing shared caches can be removed unless they are in use by an earlier release. For more information about deleting a shared classes cache, see the <tt>-Xshareclasses</tt> option.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/6234">#6234</a></td>
<td valign="top">Performance improvements for JVMTI watched fields on IBM Power&reg; systems</td>
<td valign="top">OpenJDK8 and later (AIX&reg; and Linux on POWER)</td>
<td valign="top">In earlier releases, performance improvements were introduced for JVMTI watched fields on x86, Linux on Z, and z/OS systems. These
improvements are now available for AIX and Linux on POWER systems.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/6713">#6713</a></td>
<td valign="top">Support for Transparent HugePage allocation by default</td>
<td valign="top">OpenJDK8 and later (Linux on x86)</td>
<td valign="top">In release 0.15, support was introduced for Transparent HugePage on Linux when the <tt>madvise</tt> (<tt>/sys/kernel/mm/transparent_hugepage/enabled</tt>) setting is set by specifying the <tt>-XX:+TransparentHugePage</tt> option on the command line. This support is now enabled by default for Linux on x86 systems. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/5164">#5164</a></td>
<td valign="top">New <tt>jcmd</tt> tool</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">For compatibility, OpenJ9 includes an independent implementation of the <tt>jcmd</tt> tool, which can run diagnostic commands on a specified VM or VMs.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/3743">#3743</a></td>
<td valign="top">Automatically setting an initial heap size by default</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">In release 0.15, a new feature was introduced that allowed OpenJ9 to learn and set an appropriate initial heap size for an application as an alternative to a user manually sizing and setting an <tt>-Xms</tt> value. This feature could be enabled by setting the <tt>-XX:+UseGCStartupHints</tt> option on the command line. This
option is now enabled by default.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/5822">#5822</a></td>
<td valign="top">Options <tt>-Xverify:none</tt> and <tt>-noverify</tt> are deprecated</td>
<td valign="top">OpenJDK13 and later</td>
<td valign="top">The <tt>-Xverify:none</tt> and <tt>-noverify</tt> options are deprecated in Java 13 and might be removed in a future release. A warning message is issued when these commands are used.</td>
</tr>

</table>


## Known Issues

The v0.16 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/2507">#2507</a></td>
<td valign="top">Restriction analyzing system (core) dumps</td>
<td valign="top">Linux and Windows</td>
<td valign="top">You must use a 32-bit JVM to look at a 32-bit core, and a 64-bit JVM to look at a 64-bit core. This restriction will be fixed in a later version of OpenJ9.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/479">#479</a></td>
<td valign="top">Non-compressed references VM builds not available</td>
<td valign="top">AIX, Linux on Z, Linux on Power</td>
<td valign="top">Non-compressed references VM builds, which support heaps larger than 57GB, are built on Linux on x86, Windows, and macOS. </td>
<td valign="top">Manual builds on other platforms are possible by following our <a href="https://github.com/eclipse-openj9/openj9/blob/master/buildenv/Build_Instructions_V8.md">detailed build instructions</a>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/897">#897</a></td>
<td valign="top">Javadoc not building some OpenJ9 extensions.</td>
<td valign="top">All platforms</td>
<td valign="top">Some API documentation is missing in the <code>build/&lt;platform&gt;/docs</code> directory.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/898">#898</a></td>
<td valign="top">Javadoc building some unsupported OpenJ9 extensions.</td>
<td valign="top">All platforms</td>
<td valign="top">Some API documentation in <code>build/&lt;platform&gt;/docs</code> is not supported with OpenJ9.</td>
<td valign="top">None</td>
</tr>

</tbody>
</table>


## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.16.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.16.0).
