<!--
* Copyright (c) 2019, 2021 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] http://openjdk.java.net/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH
* Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
-->

# Eclipse OpenJ9 version 0.17 release notes

These release notes support the [Eclipse OpenJ9 0.17 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.17/plan).

## Binaries and supported environments

OpenJ9 release 0.17 supports OpenJDK 8, 11, and 13.

Binaries are available at the AdoptOpenJDK project:

- [OpenJDK 8 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk8&jvmVariant=openj9)
- [OpenJDK 11 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk11&jvmVariant=openj9)
- [OpenJDK 13 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk13&jvmVariant=openj9)

All builds are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.

<b>NOTE:</b> Builds at AdoptOpenJDK are now CUDA-enabled. On systems that have the correct hardware and software pre-requisites, certain processing
tasks can be offloaded to a graphics processing unit (GPU). For more information, read the [user documentation](https://www.eclipse.org/openj9/docs/introduction/#exploiting-gpus).

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).


## Notable changes in this release

The following table covers notable changes in v0.17. Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.17/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>


<tr><td valign="top"><a href="https://github.com/ibmruntimes/openj9-openjdk-jdk8/pull/324">#324</a> <a href="https://github.com/ibmruntimes/openj9-openjdk-jdk11/pull/191">#191</a></td>
<td valign="top">OpenSSL Digest algorithm is reenabled</td>
<td valign="top">OpenJDK8 and 11</td>
<td valign="top">Following the resolution of issue [#5611](https://github.com/eclipse-openj9/openj9/issues/5611), the Digest algorithm is reenabled. This algorithm is already supported and enabled on OpenJDK 13.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/7001">#7001</a></td>
<td valign="top">New shared classes cache <tt>-Xshareclasses:noPersistentDiskSpaceCheck</tt> option </td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">For file systems that do not support the checking of free space, this option causes the VM to skip the disk space check operation that is done before creating a persistent shared classes cache.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/7149">#7149</a></td>
<td valign="top">New option <tt>-XX:[+|-]ShareUnsafeClasses</tt> </td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">Provides the ability to enable and disable the storing and finding of Unsafe classes in the shared classes cache, which are created with <tt>Unsafe.defineClass</tt>. This option is enabled by default.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/7089">#7089</a></td>
<td valign="top">New option <tt>-XX:[+|-]ClassRelationshipVerifier</tt> </td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">Provides the ability to enable and disable the recording and lazy validating of class relationships in the verifier. When enabled, unnecessary class loading is avoided, which can reduce VM startup time. This option is disabled by default and cannot be used with <tt>-Xfuture</tt>, which is also enabled when the <tt>-Xverify:all</tt> option is set. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/7213">#7213</a></td>
<td valign="top">New experimental <tt>-Xshareclasses</tt> sub-options for creating layered caches</td>
<td valign="top">OpenJDK8 and later (64-bit only)</td>
<td valign="top">The <tt>-Xshareclasses:createLayer</tt> and <tt>-Xshareclasses:layer=<number></tt> options can be used to
create layered caches, where a cache builds on another cache with the same name. Further options (<tt>printTopLayerStats</tt> and
<tt>destroyAllLayers</tt>) are also available for managing layered caches. These options are experimental.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/5884">#5884</a></td>
<td valign="top">Support for the IBM z15 processor</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">This release adds JIT compiler support for exploiting z15 instructions.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/7332">#7332</a></td>
<td valign="top">Change to default value of <tt>-Dcom.ibm.enableClassCaching=[true|false]</tt></td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">In earlier releases the default value for this option was <tt>true</tt>. The value for this option is now <tt>false</tt>, disabling LUDCL whilst
[issue 7332](https://github.com/eclipse-openj9/openj9/issues/7332) is investigated.
</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/6822">#6822</a></td>
<td valign="top">Change to Java dump output for HOOKS</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">Output for internal VM event callbacks is changed from milliseconds to microseconds. A new field, <tt>3HKTOTALTIME</tt>, provides
the total duration of previous events. Hook data is now reset after each Java dump. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/7064">#7064</a></td>
<td valign="top">Restriction removed for analyzing system (core) dumps</td>
<td valign="top">Linux and Windows</td>
<td valign="top">In earlier releases a restriction was in place whereby you had to use a 32-bit JVM to look at a 32-bit core, and a 64-bit JVM to look at a 64-bit core. This restriction is now removed.</td>
<td valign="top">None</td>
</tr>
</table>


## Known Issues

The v0.17 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/7459">#7549</a></td>
<td valign="top">Startup regression on AIX</td>
<td valign="top">AIX (64-bit POWER)</td>
<td valign="top">A 40 - 80% startup regression is under investigation for OpenJDK 8 and 11.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/479">#479</a></td>
<td valign="top">Non-compressed references VM builds not available</td>
<td valign="top">AIX, Linux on Z, Linux on Power</td>
<td valign="top">Non-compressed references VM builds, which support heaps larger than 57GB, are built on Linux on x86, Windows, and macOS. </td>
<td valign="top">Manual builds on other platforms are possible by following our <a href="https://github.com/eclipse-openj9/openj9/blob/master/buildenv/Build_Instructions_V8.md">detailed build instructions</a>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/897">#897</a></td>
<td valign="top">Javadoc not building some OpenJ9 extensions.</td>
<td valign="top">All platforms</td>
<td valign="top">Some API documentation is missing in the <code>build/&lt;platform&gt;/docs</code> directory.</td>
<td valign="top">None</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/898">#898</a></td>
<td valign="top">Javadoc building some unsupported OpenJ9 extensions.</td>
<td valign="top">All platforms</td>
<td valign="top">Some API documentation in <code>build/&lt;platform&gt;/docs</code> is not supported with OpenJ9.</td>
<td valign="top">None</td>
</tr>

</tbody>
</table>


## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.17.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.17.0).
