<!--
* Copyright (c) 2020, 2021 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] http://openjdk.java.net/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH
* Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
-->

# Eclipse OpenJ9 version 0.19.0 release notes

These release notes support the [Eclipse OpenJ9 0.19.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.19.0/plan).

## Binaries and supported environments

OpenJ9 release 0.19.0 supports OpenJDK 14.

Binaries are available at the AdoptOpenJDK project:

- [OpenJDK 14 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk14&jvmVariant=openj9)

All builds are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).


## Notable changes in this release

The following table covers notable changes in v0.19.0. Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.19/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/8467">#8467</a></td>
<td valign="top">Change in behavior of <tt>StringBuffer</tt> and <tt>StringBuilder</tt></td>
<td valign="top">OpenJDK8 only</td>
<td valign="top"><tt>StringBuffer</tt> and <tt>StringBuilder</tt> grow differently when sized at 1 G char[] or larger. They immediately grow to the maximum possible size, which is the behavior in Java 11 and later releases. To revert to the older behavior of growing only as much as necessary, use the <tt>-Djava.lang.stringBuffer.growAggressively=false</tt> option.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/8328">#8328</a></td>
<td valign="top">Option to print code cache usage to stderr at JVM shutdown</tt></td>
<td valign="top">All versions</td>
<td valign="top">A new command line option <tt>-XX:+PrintCodeCache</tt> allows you to print the code cache memory usage to stderr at JVM shutdown.</td>
</tr>

</table>


## Known Issues

The v0.19.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/479">#479</a></td>
<td valign="top">Non-compressed references VM builds not available</td>
<td valign="top">AIX</td>
<td valign="top">Non-compressed references VM builds, which support heaps larger than 57GB, are built on Linux, Windows, and macOS. </td>
<td valign="top">Manual builds on other platforms are possible by following our <a href="https://github.com/eclipse-openj9/openj9/blob/master/buildenv/Build_Instructions_V8.md">detailed build instructions</a>.</td>
</tr>

</tbody>
</table>


## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.19.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.19.0).
