<!--
* Copyright (c) 2020, 2021 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] http://openjdk.java.net/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH
* Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
-->

# Eclipse OpenJ9 version 0.20.0 release notes

These release notes support the [Eclipse OpenJ9 0.20.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.20.0/plan).

## Binaries and supported environments

OpenJ9 release 0.20.0 supports OpenJDK 8, 11, and 14.

Binaries are available at the AdoptOpenJDK project:

- [OpenJDK 8 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk8&jvmVariant=openj9)
- [OpenJDK 11 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk11&jvmVariant=openj9)
- [OpenJDK 14 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk14&jvmVariant=openj9)

All builds are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).


## Notable changes in this release

The following table covers notable changes in v0.20.0. Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.20/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/8498">#8498</a></td>
<td valign="top">Change to default maximum heap size for Java 8</td>
<td valign="top">OpenJDK8 only</td>
<td valign="top">For consistency with Java&trade; 11, the default maximum heap size (<tt>-Xmx</tt>) is changed to be 25% of the available memory with a maximum of 25 GB. Where there is 2 GB or less of physical memory, the value set is 50% of available memory with a minimum value of 16 MB and a maximum value of 512 MB. If a JVM is not configured properly, this change might lead to increased footprint size, startup time, and longer garbage collection pause times. If you want to revert to the default setting in earlier releases of OpenJ9, use the <tt>-XX:+OriginalJDK8HeapSizeCompatibilityMode</tt> option.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/8886">#8886</a></td>
<td valign="top">Change to the behavior of the <tt>-XX:[+|-]ExitOnOutOfMemoryError</tt> option</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">The <tt>-XX:[+|-]ExitOnOutOfMemoryError</tt> option is updated to exit only on VM <tt>OutOfMemoryErrors</tt> instead of both VM and Java thrown errors to match the Hotspot option.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/8047">#8047</a></td>
<td valign="top">New option, <tt>-XX:[+|-]GlobalLockReservation</tt></td>
<td valign="top">OpenJDK8 and later (Power systems only)</td>
<td valign="top">Option <tt>-XX:[+|-]GlobalLockReservation</tt> enables a new optimization targeted towards the more efficient handling of locking and unlocking Java objects.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/8744">#8744</a></td>
<td valign="top">Improvements to the <tt>jcmd</tt> tool</td>
<td valign="top">OpenJDK8 and later</td>
<td valign="top">The <tt>jcmd</tt> tool no longer requires a filename when used with the <tt>Dump.java</tt>, <tt>Dump.snap</tt>, or <tt>Dump.system</tt> options.</td>
</tr>

</table>


## Known Issues

The v0.20.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/8034">#8034</a></td>
<td valign="top">Balanced garbage collection policy not supported</td>
<td valign="top">Linux on 64-bit ARM (AArch64)</td>
<td valign="top">The Balanced GC policy cannot be used. </td>
<td valign="top">Use an alternative GC policy, such as <tt>gencon</tt>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/8762">#8762</a></td>
<td valign="top">Concurrent Scavenge mode not supported</td>
<td valign="top">Linux on 64-bit ARM (AArch64)</td>
<td valign="top">The concurrent scavenge mode (<tt>-Xgc:concurrentScavenge</tt>) of the <tt>gencon</tt>
garbage collection policy cannot be used. </td>
<td valign="top">The <tt>gencon</tt> policy can still be used without this mode operational.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/5917">#5917</a></td>
<td valign="top">JIT dynamic loop transfer not supported</td>
<td valign="top">Linux on 64-bit ARM (AArch64)</td>
<td valign="top">Performance is not optimized in this release. </td>
<td valign="top">None. Performance will improve in a future release.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/6607">#6607</a></td>
<td valign="top">JIT recompilation not supported</td>
<td valign="top">Linux on 64-bit ARM (AArch64)</td>
<td valign="top">Performance is not optimized in this release. </td>
<td valign="top">None. Performance will improve in a future release.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/8966">#8966</a>/<a href="https://github.com/eclipse-openj9/openj9/issues/9003">#9003</a></td>
<td valign="top">AOT compilation is not working by default</td>
<td valign="top">Linux on 64-bit ARM (AArch64)</td>
<td valign="top">When using shared classes, startup performance is not optimized in this release. </td>
<td valign="top">To turn on AOT explicitly, specify the <tt>-Xquickstart</tt> or <tt>-Xaot</tt> option.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/9251">#9251</a></td>
<td valign="top">Problems reading system dumps</td>
<td valign="top">Linux on 64-bit ARM (AArch64)</td>
<td valign="top">Although core files are successfully generated on AArch64 systems, in some cases the dump viewer (<tt>jdmpview</tt>) in an Aarch64 JVM is unable to read them.</td>
<td valign="top">Read Aarch64 core files from an alternative JVM, such as x86 Linux or macOS.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/479">#479</a></td>
<td valign="top">Non-compressed references VM builds not available</td>
<td valign="top">AIX</td>
<td valign="top">Non-compressed references VM builds, which support heaps larger than 57GB, are built on Linux, Windows, and macOS. </td>
<td valign="top">Manual builds on other platforms are possible by following our <a href="https://github.com/eclipse-openj9/openj9/blob/master/buildenv/Build_Instructions_V8.md">detailed build instructions</a>.</td>
</tr>

</tbody>
</table>


## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.20.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.20.0).
