<!--
* Copyright (c) 2020, 2021 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] http://openjdk.java.net/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH
* Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
-->

# Eclipse OpenJ9 version 0.24.0 release notes

These release notes support the [Eclipse OpenJ9 0.24.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.24.0/plan).

## Supported environments

OpenJ9 release 0.24.0 supports OpenJDK 8, OpenJDK 11, and OpenJDK 15.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).


## Notable changes in this release

The following table covers notable changes in v0.24.0. Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.24/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr><td valign="top">
<a href="https://github.com/eclipse-openj9/openj9/pull/10873">#10873</a> and <a href="https://github.com/eclipse-openj9/openj9/pull/11082">#11082</a></td>
<td valign="top">Changes to message logging</td>
<td valign="top">All versions</td>
<td valign="top">The <tt>-Xsyslog</tt> option replaces the <tt>-Xlog</tt> option for message logging. For compatibility with the reference implementation a limited set of <tt>-Xlog</tt> suboptions are supported.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/10175">#10175</a></td>
<td valign="top">Support for the <tt>JAVA_OPTIONS</tt> environment variable</td>
<td valign="top">All versions</td>
<td valign="top">For compatibility with the reference implementation, OpenJ9 now supports the <tt>JAVA_OPTIONS</tt> environment variable for setting command line options.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/10521">#10521</a> and <a href="https://github.com/eclipse-openj9/openj9/pull/10668">#10668</a></td>
<td valign="top"><tt>-XX:[+|-]PortableSharedCache</tt> option support update
</td>
<td valign="top">All versions</td>
<td valign="top">This option is now supported on IBM Z systems&reg; and POWER&reg; systems.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/10819">#10819</a></td>
<td valign="top"><tt>-XX:[+|-]ShareAnonymousClasses</tt> option behavior update</td>
<td valign="top">OpenJDK 15</td>
<td valign="top">In earlier releases, this option controls the storage of VM anonymous classes in the shared classes cache for all OpenJDK versions. In this release, the option now enables and disables the storage of hidden classes in the shared classes cache on OpenJDK 15 and later versions.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/10774">#10774</a></td>
<td valign="top">Additional parameters for <tt>jcmd Dump.*</tt> commands</td>
<td valign="top">All versions</td>
<td valign="top">Additional parameters can now be included for the <tt>jcmd Dump.*</tt> commands. The default for both system and heap dumps is now <tt>request=exclusive+prepwalk</tt>. For more information, see the <a href="https://www.eclipse.org/openj9/docs/version0.24/"> user documentation</a>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/10761">#10761</a></td>
<td valign="top">Change in behavior for the <tt>jextract</tt> utility</td>
<td valign="top">All versions</td>
<td valign="top">If the build ID of the <tt>jextract</tt> utility does not match the build ID of the SDK that is recorded in the system dump, an exception message is generated. A new option, <tt>-r</tt>, is introduced to force the utility to continue. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/11000">#11000</a></td>
<td valign="top">New suboption for <tt>-Xcheck:jni</tt> for fatal JNI errors</td>
<td valign="top">All versions</td>
<td valign="top">A new <tt>abortonerror</tt> suboption for <tt>-Xcheck:jni</tt> provides diagnostic data when fatal JNI errors occur. For more information, run <tt>-Xcheck:jni:help</tt>. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/11184">#11184</a></td>
<td valign="top">New Java dump content on processor features</td>
<td valign="top">All versions</td>
<td valign="top">The ENVINFO section of a Java dump file now includes further information about processor features to help diagnose problems with JIT and AOT compilations that depend on underlying hardware. </td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/10129">#10129</a></td>
<td valign="top">Windows builds now compile with Microsoft Visual Studio 2013</td>
<td valign="top">OpenJDK 8</td>
<td valign="top">The Visual Studio redistributable files included with the build are updated to match. </td>
</tr>

</table>


## Known Issues

The v0.24.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/8034">#8034</a></td>
<td valign="top">Balanced garbage collection policy not supported</td>
<td valign="top">Linux on 64-bit ARM (AArch64)</td>
<td valign="top">The Balanced GC policy cannot be used. </td>
<td valign="top">Use an alternative GC policy, such as <tt>gencon</tt>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/479">#479</a></td>
<td valign="top">Non-compressed references VM builds not available</td>
<td valign="top">AIX</td>
<td valign="top">Non-compressed references VM builds, which support heaps larger than 57GB, are built on Linux, Windows, and macOS. </td>
<td valign="top">Manual builds on other platforms are possible by following our <a href="https://github.com/eclipse-openj9/openj9/blob/master/buildenv/Build_Instructions_V8.md">detailed build instructions</a>.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.24.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.24.0).
