<!--
* Copyright (c) 2021, 2022 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] http://openjdk.java.net/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH
* Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
-->

# Eclipse OpenJ9 version 0.30.0 release notes

These release notes support the [Eclipse OpenJ9 0.30.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.30.0/plan).

## Supported environments

OpenJ9 release 0.30.0 supports OpenJDK 8, 11 and 17.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.30.0. Further information about these changes can be found in the [user documentation](https://eclipse.org/openj9/docs/version0.30/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/13199">#13199</a></td>
<td valign="top">Changes to the shared classes cache generation number</td>
<td valign="top">All versions</td>
<td valign="top">The format of classes that are stored in the shared classes cache is changed, which causes the JVM to create a new shared classes cache rather than re-creating or reusing an existing cache. To save space, you can remove all existing shared caches unless they are in use by an earlier release.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/13579">#13579</a></td>
<td valign="top">Java dumps now identify any command-line arguments that were ignored.</td>
<td valign="top">All versions</td>
<td valign="top">If any arguments are ignored, the group is introduced with <tt>1CIIGNOREDARGS</tt>, followed by a line beginning with <tt>2CIIGNOREDARG</tt> for each ignored argument.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/14042">#14042</a></td>
<td valign="top">New <tt>-XX:[+|-]EnsureHashed</tt> option added</td>
<td valign="top">All versions</td>
<td valign="top">This option specifies/unspecifies classes of objects that will be hashed and extended with a hash slot upon object creation or first move. This option may improve performance for applications that frequently hash objects of a certain type.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/12043">#12043</a></td>
<td valign="top">Redesigned balanced GC policy heap resizing</td>
<td valign="top">All versions</td>
<td valign="top">Eden and non-Eden heap resizing heuristics are redesigned to include more criteria (CPU overhead, heap occupancy, pause target time) and their relative sizing for fully expanded heap is made far more dynamic. A few existing command line options for fine tuning of resizing heuristics are now made avaialable for balanced GC policy, too.</td>
</tr>

</tbody>
</table>

## Known issues

The v0.30.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14192">#14192</td>
<td valign="top">Creating a system (core) dump on macOS 12 or later results in an error <tt>pwrite() error writing segment data:: Bad address</tt> and no system dump created.</td>
<td valign="top">macOS</td>
<td valign="top">Certain types of problems cannot be diagnosed. System dumps cannot be created by the user for analysis.</td>
<td valign="top">Use a macOS version lower than 12.</td>
</tr>

</thead>
<tbody>

</tbody>
</table>

## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.30.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.30.0).
