<!--
* Copyright (c) 2021, 2022 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] http://openjdk.java.net/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH
* Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
-->

# Eclipse OpenJ9 version 0.31.0 release notes

These release notes support the [Eclipse OpenJ9 0.31.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.31.0/plan).

**Note:** Due to delays in the 0.31 release, a final build was not created. See the 0.32 release for Java 18 support.

## Supported environments

OpenJ9 release 0.31.0 supports OpenJDK 18.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.31.0. Further information about these changes can be found in the [user documentation](https://eclipse-openj9.github.io/openj9-docs/version0.31/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/3627">#3267</a></td>
<td valign="top">New <tt>-XX:[+|-]ShowHiddenFrames</tt> option added</td>
<td valign="top">All versions</td>
<td valign="top">This option controls if hidden method frames generated for MethodHandles are displayed in a stacktrace. This option is disabled by default and can be enabled for debugging purposes.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/13925">#13925</a></td>
<td valign="top">New <tt>SharedClassStatistics</tt> API added</td>
<td valign="top">All versions</td>
<td valign="top">New shared classes API is added in <tt>SharedClassStatistics</tt> for <tt>cacheDir()</tt>, <tt>cacheName()</tt>, <tt>cachePath()</tt>, <tt>numberAttached()</tt>.
For more details see the API documentation. Only the Java 18 API documentation is updated in this release, API documentation for the other versions will be updated in the next release.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/14623">#14623</a></td>
<td valign="top">Modified default for <tt>-XX:MaxDirectMemorySize</tt></td>
<td valign="top">Java 11 and later</td>
<td valign="top">In Java 11 and later, <tt>-XX:MaxDirectMemorySize</tt> is no longer set by default and the class library limits the amount of heap memory used for
Direct Byte Buffers to the same value as the maximum heap size. Previously the limit was 87.5% of the maximum heap size.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/11164">#11164</a></td>
<td valign="top">Early access release for Apple Silicon macOS</td>
<td valign="top">Apple Silicon macOS</td>
<td valign="top">Build for Apple Silicon (AArch64) macOS is available as an early access release.  It is stable enough for evaluation but not suitable for production yet.</td>
</tr>

</tbody>
</table>

## Known issues

The v0.31.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>

<tbody>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13767">#13767</a></td>
<td valign="top">Compressed references mode is not available</td>
<td valign="top">Apple Silicon macOS (early access)</td>
<td valign="top">You can use only the large heap (non-compressed references) mode.</td>
<td valign="top">None</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14387">#14387</a></td>
<td valign="top">DDR is not enabled</td>
<td valign="top">Apple Silicon macOS (early access)</td>
<td valign="top">You cannot use DDR (Direct Dump Reader) functionalities.</td>
<td valign="top">None</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14390">#14390</a></td>
<td valign="top">Restriction with JVMTI extension functions</td>
<td valign="top">Apple Silicon macOS (early access)</td>
<td valign="top">A number of JVMTI extension functions do not work as expected.</td>
<td valign="top">Avoid using JVMTI extension functions.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14502">#14502</a></td>
<td valign="top">JIT field watch fails to work</td>
<td valign="top">Apple Silicon macOS (early access)</td>
<td valign="top">Enabling JIT field watch may cause bus errors.</td>
<td valign="top">Avoid using the <tt>-XX:+JITInlineWatches</tt> option.</td>
</tr>

</tbody>
</table>

