# This makefile is generated using an UMA template.

# Copyright (c) 2015, 2020 IBM Corp. and others
#
# This program and the accompanying materials are made available under
# the terms of the Eclipse Public License 2.0 which accompanies this
# distribution and is available at https://www.eclipse.org/legal/epl-2.0/
# or the Apache License, Version 2.0 which accompanies this distribution and
# is available at https://www.apache.org/licenses/LICENSE-2.0.
#
# This Source Code may also be made available under the following
# Secondary Licenses when the conditions for such availability set
# forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
# General Public License, version 2 with the GNU Classpath
# Exception [1] and GNU General Public License, version 2 with the
# OpenJDK Assembly Exception [2].
#
# [1] https://www.gnu.org/software/classpath/license.html
# [2] http://openjdk.java.net/legal/assembly-exception.html
#
# SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception

# UMA_PATH_TO_ROOT can be overridden by a command-line argument to 'make'.
UMA_PATH_TO_ROOT ?= ../
OMR_DIR ?= $(UMA_PATH_TO_ROOT)/omr

# top_srcdir is the top of the omr source tree
top_srcdir := $(OMR_DIR)
include $(top_srcdir)/omrmakefiles/configure.mk

# THREAD_SRCDIR is the location of the j9thread source code.
THREAD_SRCDIR := $(top_srcdir)/thread/

# UMA fills in the stream-specific name of the j9thr shared library, e.g. j9thr29.
MODULE_NAME_NOSTREAM := j9thr
MODULE_NAME := $(MODULE_NAME_NOSTREAM)${uma.buildinfo.version.major}${uma.buildinfo.version.minor}
ARTIFACT_TYPE := c_shared

include $(THREAD_SRCDIR)thread_include.mk

# J9 requires that a copyright string be embedded into the DLL.
# Append it and its location to the list of objects.
OBJECTS += copyright$(OBJEXT)
vpath copyright.c $(UMA_PATH_TO_ROOT)makelib

ifeq (win,$(OMR_HOST_OS))
# J9 requires a resource file. The .rc is generated by UMA.
RCFLAGS += $(call buildCPPIncludeFlags,$(MODULE_INCLUDES) $(GLOBAL_INCLUDES))

# compilation rule for resource files.
%.res : %.rc
	$(RC) $(RCFLAGS) $<

OBJECTS += $(MODULE_NAME_NOSTREAM).res
endif # Windows

# Write the DLL export file
#
# UMA generates export files named j9thr.exp (on Linux) or j9thr.def (on Windows),
# with no stream suffix, which will be ignored.
#
# Instead, omrmakefiles/rules.mk generates a file called $(MODULE_NAME).exp
# or $(MODULE_NAME).def, using EXPORT_FUNCTIONS_FILE. The content of the exported
# functions list varies depending on OMR_HOST_OS and what OMR buildflags are enabled.
#
# WRITE_THREAD_EXPORTS is defined in $(THREAD_SRCDIR)thread_include.mk.
#
EXPORT_FUNCTIONS_FILE := $(MODULE_NAME).exportlist
$(EXPORT_FUNCTIONS_FILE) :
	$(WRITE_THREAD_EXPORTS)

clean : clean_exports
clean_exports :
	-$(RM) $(EXPORT_FUNCTIONS_FILE)
.PHONY : clean_exports

MODULE_STATIC_LIBS += j9pool omrutil

ifeq (linux,$(OMR_HOST_OS))
MODULE_SHARED_LIBS += rt

# on Linux, we need to link the .so against libpthread. If we don't,
# pthread_attr_setstacksize will have no effect. We don't really
# understand why this is, but it probably has something to do with
# weak symbols.
MODULE_SHARED_LIBS += pthread
endif # Linux

include $(top_srcdir)/omrmakefiles/rules.mk

ifeq (win,$(OMR_HOST_OS))
# HACK:
# When UMA artifacts link this DLL, UMA omits the stream suffix (e.g. "28", "29")
# from the import library name.
# Make a copy of the import library with the name that UMA expects.
# We need both files because OMR makefile rules look for the import library
# _with_ the stream suffix in its name.
.NOTPARALLEL :

all : $(lib_output_dir)/$(MODULE_NAME_NOSTREAM).lib
$(lib_output_dir)/$(MODULE_NAME_NOSTREAM).lib : $(lib_output_dir)/$(MODULE_NAME).lib
	cp $< $@
endif # Windows
