<!--
  Copyright (c) 2018, 2018 IBM Corp. and others
 
  This program and the accompanying materials are made available under
  the terms of the Eclipse Public License 2.0 which accompanies this
  distribution and is available at https://www.eclipse.org/legal/epl-2.0/
  or the Apache License, Version 2.0 which accompanies this distribution and
  is available at https://www.apache.org/licenses/LICENSE-2.0.
 
  This Source Code may also be made available under the following
  Secondary Licenses when the conditions for such availability set
  forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
  General Public License, version 2 with the GNU Classpath
  Exception [1] and GNU General Public License, version 2 with the
  OpenJDK Assembly Exception [2].
 
  [1] https://www.gnu.org/software/classpath/license.html
  [2] http://openjdk.java.net/legal/assembly-exception.html
 
  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
-->
# Introduction

This directory holds the various modules used for testing method visibility between modules.
The module-info files are in a separate non-source directory because Eclipse
allows only one module per project.  
The org.openj9test.modularity modules are as follows:

* common: contains the tester interface defining the test methods

* testerModule: contains the  actual test implementation.  An instance of the test class is created via reflection and cast to the tester interface.

* moduleA, moduleB, moduleC, moduleD: These selectively export packages with various conditions: opens, transitive requirements, etc.

The packages need to be in separate module, hence separate directories, to test the visibility restrictions.
The build script compile target compiles the classes with all the other test suites.  The build_moduletest  
copies the various compiled classes to the module directories.  
It also creates special test class files using
the Java assembler. 

The modularity test does not use GeneralTest.jar since it makes all the classes visible.  
Instead, the tests are run out of the module directories generated by the build script.

A separated testng.xml file is required because the main testng.xml file refers to classes related 
to other tests.  These are not visible because of the 
special class/module path and will cause the test to fail.