/*******************************************************************************
 * Copyright (c) 2001, 2018 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package j9vm.test.classloader;


class MyClassLoader extends ClassLoader {
	public static int COUNT = 0;

	public static final int[] class_Empty = {
		/* Byte contents of j9vm\test\classloader\Empty.class: */
		/* class Empty {} */
	    0xCA,0xFE,0xBA,0xBE,0x00,0x03,0x00,0x2D,0x00,0x10,0x01,0x00,0x1B,0x6A,0x39,0x76,
    	0x6D,0x2F,0x74,0x65,0x73,0x74,0x2F,0x63,0x6C,0x61,0x73,0x73,0x6C,0x6F,0x61,0x64,
    	0x65,0x72,0x2F,0x45,0x6D,0x70,0x74,0x79,0x07,0x00,0x01,0x01,0x00,0x10,0x6A,0x61,
	    0x76,0x61,0x2F,0x6C,0x61,0x6E,0x67,0x2F,0x4F,0x62,0x6A,0x65,0x63,0x74,0x07,0x00,
	    0x03,0x01,0x00,0x06,0x3C,0x69,0x6E,0x69,0x74,0x3E,0x01,0x00,0x03,0x28,0x29,0x56,
	    0x01,0x00,0x04,0x43,0x6F,0x64,0x65,0x0C,0x00,0x05,0x00,0x06,0x0A,0x00,0x04,0x00,
	    0x08,0x01,0x00,0x0F,0x4C,0x69,0x6E,0x65,0x4E,0x75,0x6D,0x62,0x65,0x72,0x54,0x61,
	    0x62,0x6C,0x65,0x01,0x00,0x12,0x4C,0x6F,0x63,0x61,0x6C,0x56,0x61,0x72,0x69,0x61,
	    0x62,0x6C,0x65,0x54,0x61,0x62,0x6C,0x65,0x01,0x00,0x04,0x74,0x68,0x69,0x73,0x01,
	    0x00,0x1D,0x4C,0x6A,0x39,0x76,0x6D,0x2F,0x74,0x65,0x73,0x74,0x2F,0x63,0x6C,0x61,
	    0x73,0x73,0x6C,0x6F,0x61,0x64,0x65,0x72,0x2F,0x45,0x6D,0x70,0x74,0x79,0x3B,0x01,
	    0x00,0x0A,0x53,0x6F,0x75,0x72,0x63,0x65,0x46,0x69,0x6C,0x65,0x01,0x00,0x0A,0x45,
	    0x6D,0x70,0x74,0x79,0x2E,0x6A,0x61,0x76,0x61,0x00,0x20,0x00,0x02,0x00,0x04,0x00,
	    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x05,0x00,0x06,0x00,0x01,0x00,0x07,0x00,
	    0x00,0x00,0x2F,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x05,0x2A,0xB7,0x00,0x09,0xB1,
	    0x00,0x00,0x00,0x02,0x00,0x0A,0x00,0x00,0x00,0x06,0x00,0x01,0x00,0x00,0x00,0x04,
	    0x00,0x0B,0x00,0x00,0x00,0x0C,0x00,0x01,0x00,0x00,0x00,0x05,0x00,0x0C,0x00,0x0D,
	    0x00,0x00,0x00,0x01,0x00,0x0E,0x00,0x00,0x00,0x02,0x00,0x0F
	};

	public synchronized Class loadClass(String name) {
		COUNT ++;
		System.out.println("-->"+name);
		return loadClass();
	} //CHECK FOR INFINITE LOOP

	public synchronized Class loadClass() {
		byte[] bytes = new byte[class_Empty.length];
		for (int i = 0; i<class_Empty.length; i++)  bytes[i] = (byte)class_Empty[i];

		return defineClass("j9vm.test.classloader.Empty",bytes,0,bytes.length);
	}

}
