/*******************************************************************************
 * Copyright IBM Corp. and others 2019
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License, v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception [1] and GNU General Public
 * License, version 2 with the OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 *******************************************************************************/

#ifndef CODEGENERATOR_UTILS_INCL
#define CODEGENERATOR_UTILS_INCL

/**
 * A collection of utility functions to be used during code generation.  These
 * are standalone functions.
 *
 * They should not be included within component header files of extensible classes
 * due to the risk of introducing circular include dependencies.
 *
 * The functions may be in the public (TR) or project-specific namespaces (e.g., OMR)
 * depending upon how they are expected to be used.
 */

#include "codegen/OMRCodeGeneratorUtils.hpp"

#endif
