/*******************************************************************************
 * Copyright IBM Corp. and others 2000
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License, v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception [1] and GNU General Public
 * License, version 2 with the OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 *******************************************************************************/

#ifndef TR_LOCALVALUEPROPAGATION_INCL
#define TR_LOCALVALUEPROPAGATION_INCL

#include "optimizer/ValuePropagation.hpp"

namespace TR {

/** \class LocalValuePropagation
 *
 *  \brief An optimization that propagates value constraints within a block.

 *  The local value propagation optimization can conduct constant, type
 *  and relational propagation within a block. It propagates constants
 *  and types based on assignments and performs removal of subsumed checks
 *  and compares. Also performs devirtualization of calls, checkcast and
 *  array store check elimination.  It does not do value numbering, instead
 *  works on the assumption that every expression has a unique value
 *  number (improved effectiveness if expressions having same value are
 *  commoned by a prior local common subexpression elimination pass).
 *
 * \note
 *  The class is not intented to be extended, ValuePropagation is the core
 *  engine and home to extension points of language specific optimizations
 */
class LocalValuePropagation : public TR::ValuePropagation {
public:
    LocalValuePropagation(TR::OptimizationManager *manager);

    static TR::Optimization *create(TR::OptimizationManager *manager)
    {
        return new (manager->allocator()) TR::LocalValuePropagation(manager);
    }

    virtual int32_t perform();
    virtual int32_t performOnBlock(TR::Block *);
    virtual void prePerformOnBlocks();
    virtual void postPerformOnBlocks();
    virtual const char *optDetailString() const throw();

private:
    TR::TreeTop *processBlock(TR::TreeTop *start);
};
} // namespace TR
#endif
