/*******************************************************************************
 * Copyright IBM Corp. and others 2000
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License, v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception [1] and GNU General Public
 * License, version 2 with the OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 *******************************************************************************/

#ifndef TR_ILBUILDER_INCL
#define TR_ILBUILDER_INCL

#include "ilgen/TestIlBuilder.hpp"

namespace TR
{
   class IlBuilder : public TestCompiler::IlBuilder
      {
      public:
         IlBuilder(TR::MethodBuilder *methodBuilder, TypeDictionary *types, int32_t bcIndex=-1)
            : TestCompiler::IlBuilder(methodBuilder, types, bcIndex)
            { }

         IlBuilder(TR::IlBuilder *source)
            : TestCompiler::IlBuilder(source)
            { }

         IlBuilder(TestCompiler::TestDriver *test, TR::MethodBuilder *methodBuilder, TR::TypeDictionary *types, int32_t bcIndex=-1)
            : TestCompiler::IlBuilder(test, methodBuilder, types, bcIndex)
            { }
      };

} // namespace TR

#endif // !defined(TR_ILBUILDER_INCL)
