<!--
* Copyright IBM Corp. and others 2020
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.23.0 release notes

These release notes support the [Eclipse OpenJ9 0.23.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.23.0/plan).

## Binaries and supported environments

OpenJ9 release 0.23.0 supports OpenJDK 8, OpenJDK 11, and OpenJDK 15.

Binaries are available at the AdoptOpenJDK project:

- [OpenJDK 8 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk8&jvmVariant=openj9)
- [OpenJDK 11 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk11&jvmVariant=openj9)
- [OpenJDK 15 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk15&jvmVariant=openj9)

All builds are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).


## Notable changes in this release

The following table covers notable changes in v0.23.0. Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.23/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr><td valign="top">
<a href="https://github.com/eclipse-openj9/openj9/pull/10305">#10305</a></td>
<td valign="top"><tt>-XX:[+|-]PortableSharedCache</tt> option behavior changee</td>
<td valign="top">All versions (x86 only)</td>
<td valign="top">This option is improved in this release to increase the portability of AOT-compiled code.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/10507">#10507</a></td>
<td valign="top">-XX:[+|-]IdleTuningCompactOnIdle option now inactive</td>
<td valign="top">All versions</td>
<td valign="top">This deprecated option, which only applied to Linux systems, now has no effect. Instead, a compaction is triggered by internal heuristics that look into the number of fragmented pages.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/10386">#10386</a></td>
<td valign="top">Support added for <tt>-XX:[+|-]AlwaysPreTouch</td>
<td valign="top">All versions</td>
<td valign="top">For compatibility with the reference implementation, OpenJ9 now supports this option.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/6914">#6914</a></td>
<td valign="top">JITServer technology preview extended to Linux on Power and Linux on Z</td>
<td valign="top">OpenJDK8 and 11 (Linux x86-64, Linux on Power and Linux on Z only)</td>
<td valign="top">JITServer decouples the JIT compiler from the OpenJ9 VM, freeing up CPU and memory for an application. JITServer then runs in its own process, either locally or on a remote machine, where resources can be separately managed.</td>
</tr>

</table>

## Known Issues

The v0.23.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/8034">#8034</a></td>
<td valign="top">Balanced garbage collection policy not supported</td>
<td valign="top">Linux on 64-bit ARM (AArch64)</td>
<td valign="top">The Balanced GC policy cannot be used. </td>
<td valign="top">Use an alternative GC policy, such as <tt>gencon</tt>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/479">#479</a></td>
<td valign="top">Non-compressed references VM builds not available</td>
<td valign="top">AIX</td>
<td valign="top">Non-compressed references VM builds, which support heaps larger than 57GB, are built on Linux, Windows, and macOS. </td>
<td valign="top">Manual builds on other platforms are possible by following our <a href="https://github.com/eclipse-openj9/openj9/blob/master/buildenv/Build_Instructions_V8.md">detailed build instructions</a>.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.23.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.23.0).
