<!--
* Copyright IBM Corp. and others 2020
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.25.0 release notes

These release notes support the [Eclipse OpenJ9 0.25.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.25.0/plan).

## Supported environments

OpenJ9 release 0.25.0 supports OpenJDK 16. For a list of JDK Enhancement Proposals (JEP) that are supported by or implemented in OpenJ9, see the [release topic](https://eclipse.org/openj9/docs/version0.25/#new-jdk-16-features) in the user documentation.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).


## Notable changes in this release

The following table covers notable changes in v0.25.0. Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.25/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr><td valign="top">
<a href="https://github.com/eclipse-openj9/openj9/issues/10620">#10620</a></td>
<td valign="top">New option to support JEP 390: Warnings for value-based classes</td>
<td valign="top">OpenJDK 16</td>
<td valign="top">OpenJ9 adds option <strong>-XX:DiagnoseSyncOnValueBasedClasses=&lt;number&gt;</strong> for compatibility with the reference implementation. A value of <tt>1</tt> generates a <tt>VirtualMachineError</tt> error and a value of <tt>2</tt> prints a warning message.</td>
</tr>

<tr><td valign="top">
<a href="https://github.com/eclipse-openj9/openj9/pull/8847">#8847</a></td>
<td valign="top">Single build for compressed references and non-compressed references</td>
<td valign="top">All versions</td>
<td valign="top">A single build now supports both compressed references and non-compressed references. The object reference mode is selected at run time based on the specified heap size (<strong>-Xmx</strong>) or by using command-line options that control the selection of compressed references. If compressed references mode is automatically selected and you don't want to use compressed references, turn it off using the command-line option <strong>-Xnocompressedrefs</strong>.</td>
</tr>

<tr><td valign="top">
<a href="https://github.com/eclipse-openj9/openj9/pull/11624">#11624</a></td>
<td valign="top">Enabling zlibNX hardware-accelerated data compression and decompression on AIX&reg;</td>
<td valign="top">All versions</td>
<td valign="top">On AIX systems that contain the Nest accelerator (NX) co-processor, OpenJ9 now uses the <tt>zlibNX</tt> library instead, if it is installed. The NX co-processor is available on IBM POWER9&reg; systems.</td>
</tr>

<tr><td valign="top">
<a href="https://github.com/eclipse-omr/omr/pull/5770">#5770</a></td>
<td valign="top">z/OS&reg; support for the <strong>%sysname</strong> dump token</td>
<td valign="top">All versions</td>
<td valign="top">The <strong>%sysname</strong> dump token is added on z/OS, which equates to the <strong>SYSNAME sysparm</strong>.</td>
</tr>
</table>


## Known Issues

The v0.25.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/8034">#8034</a></td>
<td valign="top">Balanced garbage collection policy not supported</td>
<td valign="top">Linux on 64-bit ARM (AArch64)</td>
<td valign="top">The Balanced GC policy cannot be used. </td>
<td valign="top">Use an alternative GC policy, such as <tt>gencon</tt>.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.25.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.25.0).
