<!--
* Copyright IBM Corp. and others 2022
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.33.x release notes

These release notes support the [Eclipse OpenJ9 0.33.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.33.0/plan)
and the [Eclipse OpenJ9 0.33.1 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.33.1/plan).

## Supported environments

OpenJ9 release 0.33.x supports OpenJDK 8, 11, 17, 18.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.33.x. Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.33/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/15234">#15234</a></td>
<td valign="top">The undocumented option <tt>-XX:+AllowNonVirtualCalls</tt> is deprecated with OpenJDK 19 and will be removed in builds with OpenJDK 20.</td>
<td valign="top">OpenJDK 19</td>
<td valign="top">From builds with OpenJDK 20, the option <tt>-XX:+AllowNonVirtualCalls</tt> will be ignored, or will cause an error if <tt>-XX:-IgnoreUnrecognizedXXColonOptions</tt> is used.
The option cannot be supported with value types.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/15233">#15233</a></td>
<td valign="top">OpenJ9 Windows OpenJDK 8 builds now compile with Microsoft Visual Studio 2017</td>
<td valign="top">OpenJDK 8</td>
<td valign="top">The Visual Studio redistributable files included with the build are updated to match.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14190">#14190</a></td>
<td valign="top">Control groups v2 support added</td>
<td valign="top">All versions</td>
<td valign="top">The Linux&reg; kernel has two variants of <a href="https://man7.org/linux/man-pages/man7/cgroups.7.html">control groups (cgroups): v1 and v2</a>. Many Linux operating systems are gradually transitioning from cgroups v1 to v2 as their default choice. OpenJ9 has added cgroups v2 support which is identical to the support for cgroups v1.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/14978">#14978</a></td>
<td valign="top">JITServer adds support for OpenSSL 3</td>
<td valign="top">All versions</td>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9-docs/blob/master/docs/jitserver.md">JITServer technology</a> can now encrypt network traffic using OpenSSL 3.0.x, in addition to OpenSSL 1.0.x and 1.1.x</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/12153">#12153</a></td>
<td valign="top">JITServer adds supports for a server-side AOT cache</td>
<td valign="top">All versions</td>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9-docs/blob/master/docs/jitserver.md">JITServer technology</a> can now cache AOT compiled methods at the server. This can reduce the amount of CPU used by JITServer and improve AOT compilation latency.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/14762">#14762</a></td>
<td valign="top">JITServer adds supports for exporting custom metrics to monitoring agents</td>
<td valign="top">All versions</td>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9-docs/blob/master/docs/jitserver.md">JITServer technology</a> can now export custom performance metrics to a monitoring agent that follows the <a href="https://openmetrics.io/">OpenMetrics</a> protocol (for example <a href="https://prometheus.io/">Prometheus</a>).</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/14762">#14762</a></td>
<td valign="top">JITServer adds supports for exporting custom metrics to monitoring agents</td>
<td valign="top">All versions</td>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9-docs/blob/master/docs/jitserver.md">JITServer technology</a> can now export custom performance metrics to a monitoring agent that follows the <a href="https://openmetrics.io/">OpenMetrics</a> protocol (for example <a href="https://prometheus.io/">Prometheus</a>).</td>
</tr>

</tbody>
</table>

## Known issues

The v0.33.x release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>

<tbody>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15011">#15011</a></td>
<td valign="top">The default stack size is modified for the main thread</td>
<td valign="top">All</td>
<td valign="top">The main thread stack size was 1 MB in releases prior to 0.32. In the 0.32 release and later it's modified to a smaller
platform-dependent value, the same value as the <tt>-Xmso</tt> setting. The 0.33 release increases the default <tt>-Xmso</tt> stack size
on x64 platforms, but builds with OpenJDK 17 and later also require more stack space to run. These changes may result in a
<tt>java.lang.StackOverflowError: operating system stack overflow</tt>.</td>
<td valign="top">Use <tt>-Xmso</tt> to set the default stack size. See the default value by using <tt>-verbose:sizes</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/11164">#11164</a></td>
<td valign="top">Early access release for Apple Silicon macOS</td>
<td valign="top">Apple Silicon macOS / OpenJDK 11 and later</td>
<td valign="top">Build for Apple Silicon (AArch64) macOS is available as an early access release.  It is stable enough for evaluation but not suitable for production yet.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13767">#13767</a></td>
<td valign="top">Compressed references mode is not available</td>
<td valign="top">Apple Silicon macOS (early access)</td>
<td valign="top">You can use only the large heap (non-compressed references) mode.</td>
<td valign="top">None</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15697">#15697</a></td>
<td valign="top">In the 0.33.0 release, the -XX:+PortableSharedCache option doesn't necessarily create portable AOT.</td>
<td valign="top">x86 platforms (Linux, Windows, Mac)</td>
<td valign="top">When the -XX:+PortableSharedCache option is used, such as in docker containers, startup time may be regressed from previous releases
if running on a Skylake or later processor.</td>
<td valign="top">Upgrade to the 0.33.1 release.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15716">#15716</a></td>
<td valign="top">In the 0.33.0 release, vector registers are saved unconditionally for no reason.</td>
<td valign="top">OpenJDK 17 and later on x86 platforms (Linux, Windows, Mac)</td>
<td valign="top">Performance may be regressed from previous releases.</td>
<td valign="top">Upgrade to the 0.33.1 release.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-omr/omr/pull/6432">#6432</a></td>
<td valign="top">If you mount the <tt>/proc</tt> file system with the <tt>hidepid=2</tt> option on Linux systems and the VM does not have root privileges, it cannot access the <tt>/proc/1/cgroup</tt> file and the container detection fails.</td>
<td valign="top">All versions (Linux)</td>
<td valign="top">The VM fails to start when the container detection code cannot access the <tt>/proc/1/cgroup</tt> file.</td>
<td valign="top">Remount the <tt>/proc</tt> file system with the <tt>hidepid=0</tt> option or remount the <tt>/proc</tt> file system with the <tt>gid</tt> option to allow users in a certain group to access the <tt>/proc</tt> file system.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for the 0.33.0 release is available at [Eclipse OpenJ9 v0.33.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.33.0).
A full commit history for the 0.33.1 release is available at [Eclipse OpenJ9 v0.33.1](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.33.1).
