<!--
* Copyright IBM Corp. and others 2023
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.36.x release notes

These release notes support  the [Eclipse OpenJ9&trade; 0.36.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.36.0/plan) and the [Eclipse OpenJ9 0.36.1 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.36.1/plan).

## Supported environments

OpenJ9 release 0.36.0 supports OpenJDK 8 and 17.

Release 0.36.1 supports OpenJDK 11.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.36.x. Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.36/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16532">#16532</a></td>
<td valign="top">Support for running OpenJDK 8 and OpenJDK 11 on CentOS 6.10 is deprecated and might be removed in a future release.</td>
<td valign="top">OpenJDK 8 and 11 (CentOS 6.10)</td>
<td valign="top">OpenJ9 will no longer test OpenJDK 11 on CentOS 6.10 after 0.36.1 release and might stop testing OpenJDK 8 in the future.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16256">#16256</a></td>
<td valign="top">The location of the default directory for the shared cache and snapshot is changed to the <tt>.cache/javasharedresources</tt> in the user's home directory.</td>
<td valign="top">All versions (AIX&reg;, Linux&reg;, macOS&reg;)</td>
<td valign="top">This change is for non-Windows&trade; and non-z/OS&reg; platforms and applies only if <tt>-Xshareclasses:groupAccess</tt> is not used. If <tt>groupAccess</tt> is used, the directory that gets set remains as <tt>/tmp/javasharedresources/</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16133">#16133</a></td>
<td valign="top">New <tt>-XX:[+|-]MergeCompilerOptions</tt> option is added to enable or disable the merging of multiple -Xjit or -Xaot options into a single -Xjit or -Xaot option.</td>
<td valign="top">All versions</td>
<td valign="top"> By default, if you specify <tt>-Xjit</tt> option (or <tt>-Xaot</tt> option) multiple times, only the last option takes effect. Therefore, on adding an <tt>-Xjit</tt> option, the resultant behavior might not be as expected, if any instance of this option already exists. You can use the <tt>-XX:+MergeCompilerOptions</tt> option to merge all the existing instances of the <tt>-Xjit</tt> options logically.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16166">#16166</a></td>
<td valign="top">Default JITServer AOT cache is named as <tt>default</tt>.</td>
<td valign="top">All versions (Linux)</td>
<td valign="top">A JITServer instance can have several AOT caches, each with its own name and containing different versions of compiled methods. Client JVMs with different profiles of execution can connect to the same JITServer instance, but access the cache with compiled methods optimized for their own profile with the <tt>-XX:JITServerAOTCacheName</tt> option. Earlier, if the cache name was not specified in this option, the default was to use a nameless cache. The default AOT cache name is now changed to <tt>default</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15775">#15775</a></td>
<td valign="top">New <tt>-XX:JITServerAOTmx</tt> option is added for specifying the maximum amount of memory that can be used by the JITServer AOT cache.</td>
<td valign="top">All versions (Linux)</td>
<td valign="top">The maximum amount of memory that all the AOT cache instances combined can use at the server is 300 MB, by default. You can change this value by using the <tt>-XX:JITServerAOTmx=&ltsize&gt</tt> option. When the cache size reaches the specified limit, new clients cannot create new AOT cache instances or add new compiled methods to the existing AOT cache instances.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16075">#16075</a></td>
<td valign="top">New <tt>-XX:[+|-]JITServerAOTCachePersistence</tt> option is added to specify whether the JITServer server periodically saves its AOT caches to files.</td>
<td valign="top">All versions (Linux)</td>
<td valign="top">With the <tt>-XX:+JITServerAOTCachePersistence</tt> option, the JITServer server periodically saves its AOT caches to files. Other JITServer instances can then load these caches the first time that a client requests a particular cache. This feature is useful to improve performance, especially in scenarios where JITServer instances are started up and shut down regularly.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16075">#16075</a></td>
<td valign="top">New <tt>-XX:JITServerAOTCacheDir</tt> option is added to specify the directory to be used for saving and loading JITServer AOT cache files.</td>
<td valign="top">All versions (Linux)</td>
<td valign="top">If the JITServer AOT cache persistence feature is enabled (<tt>-XX:+JITServerAOTCachePersistence</tt>) and the client JVM asks for an AOT cache that is not already present in server's memory, the server attempts to load the named AOT cache from file. You can use the <tt>-XX:JITServerAOTCacheDir=&ltdirectory&gt</tt> option to specify the directory where the AOT cache must be saved to or loaded from.</td>
</tr>

</tbody>
</table>

## Known issues

The v0.36.x release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>

<tbody>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15011">#15011</a></td>
<td valign="top">The default stack size is modified for the main thread</td>
<td valign="top">All</td>
<td valign="top">The main thread stack size was 1 MB in releases prior to 0.32. In the 0.32 release and later it's modified to a smaller
platform-dependent value, the same value as the <tt>-Xmso</tt> setting. The 0.33 release increases the default <tt>-Xmso</tt> stack size
on x64 platforms, but builds with OpenJDK 17 and later also require more stack space to run. These changes might result in a
<tt>java.lang.StackOverflowError: operating system stack overflow</tt>.</td>
<td valign="top">Use <tt>-Xmso</tt> to set the default stack size. See the default value by using <tt>-verbose:sizes</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13767">#13767</a></td>
<td valign="top">Compressed references mode is not available</td>
<td valign="top">Apple silicon macOS</td>
<td valign="top">You can use only the large heap (non-compressed references) mode.</td>
<td valign="top">None</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14803">#14803</a></td>
<td valign="top">Using the <tt>-XX:+ShowHiddenFrames</tt> option in an OpenJ9 release that is built with OpenJDK 18 and later causes errors due to underlying problems in OpenJDK</td>
<td valign="top">All platforms</td>
<td valign="top">Wrong exception might be thrown when using the Reflection API.</td>
<td valign="top">Avoid using the <tt>-XX:+ShowHiddenFrames</tt> option with OpenJDK 18 and later.</td>
</tr>

<tr>
<td valign="top">-</td>
<td valign="top">Support for OpenJDK 19 is not yet available due to outstanding issues, as listed in the <a href="https://github.com/eclipse-openj9/openj9/milestone/35">milestone 35</a> plan</td>
<td valign="top">All platforms</td>
<td valign="top">OpenJDK 19 support will be added in a future OpenJ9 release if possible before the release of OpenJDK 20 in March. This work might delay support for OpenJDK 20 (you can follow the progress of OpenJDK 20 support in the <a href="https://github.com/eclipse-openj9/openj9/milestone/40">milestone 40</a> plan). The information in the <a href=https://www.eclipse.org/openj9/docs/openj9_support/#eclipse-openj9-releases>Eclipse OpenJ9 releases table</a> in the documentation is therefore more likely to change than usual.</td>
<td valign="top">None</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16451">#16451</a></td>
<td valign="top">OpenSSL leaks native memory</td>
<td valign="top">All platforms</td>
<td valign="top">Application servers crash from memory starvation caused by OpenSSL memory leak.</td>
<td valign="top">Restart the application on a regular basis.
You can also <a href="https://www.eclipse.org/openj9/docs/djdknativecrypto">disable use of OpenSSL</a>, either in whole or in part (if you can identify the parts containing the leaks). However, disabling use of OpenSSL might have a big impact on performance.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-omr/omr/pull/6432">#6432</a></td>
<td valign="top">If you mount the <tt>/proc</tt> file system with the <tt>hidepid=2</tt> option on Linux systems and the VM does not have root privileges, it cannot access the <tt>/proc/1/cgroup</tt> file and the container detection fails.</td>
<td valign="top">All versions (Linux)</td>
<td valign="top">The VM fails to start when the container detection code cannot access the <tt>/proc/1/cgroup</tt> file.</td>
<td valign="top">Remount the <tt>/proc</tt> file system with the <tt>hidepid=0</tt> option or remount the <tt>/proc</tt> file system with the <tt>gid</tt> option to allow users in a certain group to access the <tt>/proc</tt> file system.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for 0.36.0 release is available at [Eclipse OpenJ9 v0.36.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.36.0). A full commit history for 0.36.1 release is available at [Eclipse OpenJ9 v0.36.1](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.36.1).
