<!--
* Copyright (c) 2023 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.40.0 release notes

These release notes support the [Eclipse OpenJ9&trade; 0.40.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.40.0/plan).

## Supported environments

OpenJ9 release 0.40.0 supports OpenJDK 8, 11, 17 and 20.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.40.0. Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.40/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/17073">#17073</a></td>
<td valign="top">Support for persistent shared classes cache is now added on z/OS&reg; systems</td>
<td valign="top">All versions (z/OS)</td>
<td valign="top">Persistent shared caches are now supported on z/OS systems. With the 31-bit VM on all versions of z/OS, the shared cache is memory mapped within the 0-2 GB address range. With the 64-bit VM on z/OS version 2.3 and earlier, the persistent shared cache is memory mapped within the 0-2 GB address range but on z/OS version 2.4 and later the shared cache is memory mapped above the 2 GB address range. </td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/17425">#17425</a></td>
<td valign="top">A new <tt>-XX:codecachetotalMaxRAMPercentage</tt> option is added to set the maximum limit for the total JIT code cache size based on the amount of physical memory available to the VM.</td>
<td valign="top">All versions</td>
<td valign="top">The new option is used to set the JIT code cache maximum size limit as a percentage of the available physical memory. In memory constrained environments, the percentage limit prevents the VM from using too much memory for its JIT code caches, leaving too little memory for other VM or JIT data structures. By default, the VM is not allowed to use more than 25% of the available physical memory for its JIT code caches.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-omr/omr/issues/7021">#7021</a></td>
<td valign="top">If you mount the <tt>/proc</tt> file system with the <tt>hidepid=2</tt> option on Linux&reg; systems and the VM does not have root privileges, it cannot access the /proc file system, and the container detection fails. But, the VM does not exit as it did in the previous releases. Now, the VM starts with a warning message.</td>
<td valign="top">All versions (Linux)</td>
<td valign="top">Although the VM starts after the container detection fails, the VM assumes that it is running outside a container. Therefore, if the VM is running in a container, the VM cannot adapt to the container's limitations and might use an undesirable amount of resources. You can evaluate the impact on performance because of the container detection failure and take steps to resolve the performance issue, if so required. For example, you can remount the <tt>/proc</tt> file system with the <tt>gid</tt> and <tt>hidepid=2</tt> options to allow some processes to access the <tt>/proc</tt> file system.</td>
</tr>

</tbody>
</table>

## Known issues

The v0.40.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>

<tbody>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15011">#15011</a></td>
<td valign="top">The default stack size for the main thread is a smaller platform-dependent value.</td>
<td valign="top">All</td>
<td valign="top">The main thread stack size was 1 MB in releases prior to 0.32. In the 0.32 release and later it was modified to a smaller
platform-dependent value, the same value as the <tt>-Xmso</tt> setting. The 0.33 release increased the default <tt>-Xmso</tt> stack size
on x64 platforms, but builds with OpenJDK 17 and later also require more stack space to run. These changes might result in a
<tt>java.lang.StackOverflowError: operating system stack overflow</tt>.</td>
<td valign="top">Use <tt>-Xmso</tt> to set the default stack size. See the default value by using <tt>-verbose:sizes</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13767">#13767</a></td>
<td valign="top">Compressed references mode is not available.</td>
<td valign="top">Apple silicon macOS</td>
<td valign="top">You can use only the large heap (non-compressed references) mode.</td>
<td valign="top">None</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14803">#14803</a></td>
<td valign="top">Using the <tt>-XX:+ShowHiddenFrames</tt> option in an OpenJ9 release that is built with OpenJDK 18 and later causes errors.</td>
<td valign="top">All platforms</td>
<td valign="top">Wrong exception might be thrown when using the Reflection API.</td>
<td valign="top">Avoid using the <tt>-XX:+ShowHiddenFrames</tt> option with OpenJDK 18 and later.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for 0.40.0 release is available at [Eclipse OpenJ9 v0.40.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.40.0).
