<!--
* Copyright (c) 2024 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.44.0 release notes

These release notes support the [Eclipse OpenJ9&trade; 0.44.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.44.0/plan).

## Supported environments

OpenJ9 release 0.44.0 supports OpenJDK 8, 11, 17, and 21.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.44.0. Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.44/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18900">#18900</a></td>
<td valign="top">Change in behavior of the <tt>-Djava.security.manager</tt> system property for OpenJDK version 8.</td>
<td valign="top">OpenJDK 8</td>
<td valign="top">

In OpenJDK versions before version 18, attempts to load a <tt>SecurityManager</tt> with the class name <tt>allow</tt> or <tt>disallow</tt> resulted in an error and the application was not starting.

To resolve this issue, OpenJDK version 17 ignores these options and from 0.41.0 release onwards, OpenJDK version 11 also ignores these options. 

With this release, OpenJDK version 8 too ignores the <tt>allow</tt> and <tt>disallow</tt> keywords, if specified.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/17990">#17990</a>, <a href="https://github.com/eclipse-openj9/openj9/issues/18845">#18845</a></td>
<td valign="top">Display of multiple warnings on loading the same agent is now restricted on AIX systems.</td>
<td valign="top">OpenJDK 21 and later (AIX)</td>
<td valign="top">Earlier, on AIX systems, warnings were issued each time the agents were loaded dynamically into a running VM after startup without specifying the `-XX:+EnableDynamicAgentLoading` option. These multiple warnings were issued even if the same agents were loaded before.

Now, from the 0.44.0 release onwards, AIX systems, like other OpenJ9 supported operating systems, can detect whether an agent was previously loaded or not. Therefore, like other platforms, on AIX systems also, the warnings are issued only once for the same agent when the `-XX:+EnableDynamicAgentLoading` option is not specified.
</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18342">#18342</a></td>
<td valign="top">XL C++ Runtime 16.1.0.7 or later is required for AIX OpenJ9 builds on OpenJDK 8.</td>
<td valign="top">OpenJDK 8 (AIX)</td>
<td valign="top">Earlier, XL C++ Runtime 16.1.0.7 or later was required for AIX OpenJ9 builds on OpenJDK 11 and later. Now, AIX OpenJ9 builds require version 16.1.0.7 or later of the XL C++ Runtime on OpenJDK 8 as well.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18218">#18218</a></td>
<td valign="top">The <tt>-XX:[+|-]ShowUnmountedThreadStacks</tt>option is added to control the inclusion of the unmounted virtual threads in a Java&trade; core file.</td>
<td valign="top">OpenJDK 21 and later</td>
<td valign="top">Java core file lists stacks of only those threads that are mapped to platform threads. An unmounted virtual thread is not mapped to any platform thread. Therefore, the stack of any unmounted virtual thread is not included in the Java core file and thus, the virtual thread information remains incomplete.

You can use the <tt>-XX:+ShowUnmountedThreadStacks</tt> option to include all the thread data that a VM is aware of, both regular Java threads and the unmounted virtual threads, in a Java core file.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/19173">#19173</a></td>
<td valign="top">Flag names that refer to the fields of <tt>J9BuildFlags</tt> are changed in the Direct Dump Reader (DDR) code</td>
<td valign="top">All versions</td>
<td valign="top">User plug-ins in the DDR code might contain code that has <tt>J9BuildFlags</tt> references to read the build flags in the system dump data. The names of <tt>J9BuildFlags</tt> fields changed over time and therefore, supporting system dumps with different build flags became a challenge.

Earlier, field names in <tt>J9BuildFlags</tt> were based on names defined in <tt>j9.flags</tt>. Now, when the <tt>J9BuildFlags</tt> is generated for each build, the flag names are those names that are specified in <tt>j9cfg.h</tt> (derived from <tt>j9cfg.h.ftl</tt> or <tt>j9cfg.h.in</tt>) instead of the names that are defined in <tt>j9.flags</tt>.

If the plug-in code contains references to fields of <tt>J9BuildFlags</tt> to read the build flags in the system dump data, you must change references to use the names as specified in <tt>j9cfg.h</tt>.
</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/19045">#19045, <a href="https://github.com/eclipse-openj9/openj9/issues/19069">#19069,</a></td>
<td valign="top">VMID query in the <tt>jcmd</tt> tool enhanced</td>
<td valign="top">All versions</td>
<td valign="top">Earlier in OpenJ9, when sending a <tt>jcmd</tt> command to a VM, you had to run <tt>jcmd -l</tt> to retrieve the pids for all the VMs found on the machine. Then, you had to use <tt>jcmd [vmid] [command]</tt> to send the command to the specific VM.

For OpenJDK compatibility, OpenJ9 now supports direct use of the Java process name, full or partial, as the ID to send the <tt>jcmd</tt> command.

The <tt>jcmd</tt> tool also now supports specifying <tt>0</tt> as a VMID to target all VMs.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/18720">#18720</a>, <a href="https://github.com/eclipse-openj9/openj9/issues/18996">#18996</a></td>
<td valign="top">A new system property, <tt>-Dcom.ibm.tools.attach.fileAccessUpdateTime</tt>, is added to prevent automatic deletion of the Attach API control files in the <tt>/tmp</tt> folder.</td>
<td valign="top">All versions (Linux&reg;)</td>
<td valign="top">In Linux environments, by default <tt>systemd-tmpfiles</tt> automatically deletes all files and directories that are stored in the <tt>/tmp/</tt> folder that have not been changed or read within a specific time period. This deletion of files creates a problem for long running VM processes, such as Attach API, that need the control files in the <tt>/tmp/</tt> folder to operate.

You can prevent the automatic deletion of the Attach API control files in the <tt>/tmp</tt> folder by setting the <tt>-Dcom.ibm.tools.attach.fileAccessUpdateTime</tt> system property. By default, this system property is set to 8 days.</td>
</tr>

<tr>
<td valign="top">N/A </td>
<td valign="top">CentOS Stream 8 is out of support.</td>
<td valign="top">All versions (CentOS Stream 8) </td>
<td valign="top">CentOS Stream 8 is EOL from May 31, 2024 onwards and is removed from the list of supported platforms.</td>
</tr>

</tbody>
</table>

## Known issues

The v0.44.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>

<tbody>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15011">#15011</a></td>
<td valign="top">The default stack size for the main thread is a smaller platform-dependent value.</td>
<td valign="top">All</td>
<td valign="top">The main thread stack size was 1 MB in releases before 0.32. In the 0.32 release and later it was modified to a smaller
platform-dependent value, the same value as the <tt>-Xmso</tt> setting. The 0.33 release increased the default <tt>-Xmso</tt> stack size
on x64 platforms, but builds with OpenJDK 17 and later also require more stack space to run. These changes might result in a
<tt>java.lang.StackOverflowError: operating system stack overflow</tt>.</td>
<td valign="top">Use <tt>-Xmso</tt> to set the default stack size. See the default value by using <tt>-verbose:sizes</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13767">#13767</a></td>
<td valign="top">Compressed references mode is not available.</td>
<td valign="top">Apple silicon macOS</td>
<td valign="top">You can use only the large heap (non-compressed references) mode.</td>
<td valign="top">None</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14803">#14803</a></td>
<td valign="top">Using the <tt>-XX:+ShowHiddenFrames</tt> option in an OpenJ9 release that is built with OpenJDK 18 and later causes errors.</td>
<td valign="top">All platforms</td>
<td valign="top">Wrong exception might be thrown when using the Reflection API.</td>
<td valign="top">Avoid using the <tt>-XX:+ShowHiddenFrames</tt> option with OpenJDK 18 and later.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/ibmruntimes/openj9-openjdk-jdk22/issues/60">#60</a></td>
<td valign="top">The <tt>-XX:+CompactStrings</tt> option is having an adverse impact on the OpenJDK 11 <tt>indexOf()</tt> method results.</td>
<td valign="top">OpenJDK 11</td>
<td valign="top"><tt>String</tt> compression is enabled by default for OpenJDK 11 and later. If you use the <tt>split()</tt>, <tt>substring()</tt>, <tt>replace(char, char)</tt>, <tt>replaceAll()</tt> methods to create a <tt>String</tt> containing only Latin-1 characters from a <tt>String</tt> that contains non-Latin-1 characters and use that new <tt>String</tt> with the <tt>indexOf()</tt> or <tt>lastIndexOf()</tt> methods, the results might be wrong.</td>
<td valign="top">Disable <tt>String</tt> compression with the <tt>-XX:-CompactStrings</tt> option or use OpenJDK 17 or later.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for 0.44.0 release is available at [Eclipse OpenJ9 v0.44.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.44.0).
