<!--
* Copyright (c) 2024 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.46.0 release notes

These release notes support the [Eclipse OpenJ9&trade; 0.46.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.46.0/plan).

## Supported environments

OpenJ9 release 0.46.0 supports OpenJDK 8, 11, 17, 21, and 22.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.46.0. Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.46/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr>
<td valign="top"><a href="https://github.com/ibmruntimes/openj9-openjdk-jdk22/pull/42">#42</a>, <a href="https://github.com/ibmruntimes/openj9-openjdk-jdk21/pull/140">#140</a>, <a href="https://github.com/ibmruntimes/openj9-openjdk-jdk17/pull/337">#337</a>, <a href="https://github.com/ibmruntimes/openj9-openjdk-jdk8/pull/743">#743</a>, <a href="https://github.com/ibmruntimes/openj9-openjdk-jdk11/pull/766">#766</a></td>
<td valign="top">MD5 message digest algorithm support is added for OpenSSL.</td>
<td valign="top">All versions (All platforms except AIX&reg;)</td>
<td valign="top">OpenSSL native cryptographic support is added for the MD5 message digest algorithm, providing improved cryptographic performance. OpenSSL support is enabled by default. If you want to turn off support for the MD5 message digest algorithm, set the <tt>-Djdk.nativedigest</tt> system property to <tt>false</tt>.</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/19436">#19436</a></td>
<td valign="top">Support is added for the <tt>com.sun.management.ThreadMXBean.getTotalThreadAllocatedBytes()</tt> API.</td>
<td valign="top">All versions</td>
<td valign="top">The OpenJ9 VM implementation supports measurement of the total memory allocation for all threads (<tt>com.sun.management.ThreadMXBean.getTotalThreadAllocatedBytes()</tt> API). The <tt>getTotalThreadAllocatedBytes()</tt> method now returns the total thread allocated bytes instead of <tt>-1</tt>.</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/19585">#19585</a>, <a href="https://github.com/eclipse-openj9/openj9/pull/19619">#19619</a></td>
<td valign="top">The JITServer AOT caching feature is enabled by default at the JITServer server.</td>
<td valign="top">All versions (Linux&reg; x86, Linux on POWER&reg; (Little Endian), and Linux on IBM Z&reg;)</td>
<td valign="top"><tt>-XX:+JITServerUseAOTCache</tt> is the default setting at the JITServer server now. That means that you don't have to specify the <tt>-XX:+JITServerUseAOTCache</tt> option at the server to enable the JITServer AOT caching feature.

Although this option is by default enabled at the server, it is still disabled for the JITServer clients. The clients that want to use the JITServer AOT caching, must still specify the <tt>-XX:+JITServerUseAOTCache</tt> option on the command line. Also, now the clients don't have to enable the shared classes cache feature to use the <tt>-XX:+JITServerUseAOTCache</tt> option.
</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/19554">#19554</a></td>
<td valign="top">The extended Hot Code Replace (HCR) capability is disabled by default and the <tt>-XX:[+|-]EnableExtendedHCR</tt> option is added to enable or disable the HCR capability.</td>
<td valign="top">All versions</td>
<td valign="top">By default, the extended HCR capability in the VM is disabled for all OpenJDK versions. You can enable the HCR capability by using the <tt>-XX:+EnableExtendedHCR</tt> option.

The extended HCR feature is deprecated in this release and will be removed in a future release. From OpenJDK 25 onwards, extended HCR will not be supported. Following that, the extended HCR support will be removed from other earlier OpenJDK versions also.
</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/19245">#19245</a>, <a href="https://github.com/eclipse-openj9/openj9/pull/19165">#19165</a></td>
<td valign="top">A new system property <tt>-Dcom.ibm.tools.attach.retry</tt> is added to improve <tt>jcmd</tt> attaching in case of the <tt>SocketException</tt> error on Windows&trade; platform.</td>
<td valign="top">All versions (Windows)</td>
<td valign="top">When the <tt>jcmd</tt> tool sends a command to a running VM, the command might throw the <tt>Socket Exception</tt> error on Windows platform. Instead of failing the attaching request, you can specify the number of times the tool retries attaching to the target VM with the new system property, <tt>-Dcom.ibm.tools.attach.retry</tt>.
</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/19070">#19070</a></td>
<td valign="top">Core allocation cache statistics per thread is included in the <tt>-Xtgc:allocation</tt> report.</td>
<td valign="top">All versions</td>
<td valign="top">The <tt>-Xtgc:allocation</tt> option prints thread-specific allocation cache (TLH) statistics in addition to the cumulative allocation statistics.
</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/19323">#19323</a>, <a href="https://github.com/eclipse-openj9/openj9/pull/19442">#19442</a></td>
<td valign="top">The <tt>-XX:[+|-]ShareOrphans</tt> option is added to control storing of orphan classes in the shared classes cache.</td>
<td valign="top">All versions</td>
<td valign="top">When <tt>-Xshareclasses</tt> was specified, only the class loaders that implemented the OpenJ9's public shared classes cache APIs (and its child class loaders) could store classes to the shared classes cache. Custom class loaders that did not implement these cache APIs couldn't pass the module or class path information to the VM. Classes of such class loaders were not stored to the cache.

Now, you can enable class sharing from all class loaders, irrespective of whether the class loader implements the shared classes cache API, with the `-XX:+ShareOrphans` option.
</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/18301">#18301</a>, <a href="https://github.com/eclipse-openj9/openj9/pull/19585">#19585</a></td>
<td valign="top">The <tt>-XX:[+|-]JITServerAOTCacheIgnoreLocalSCC</tt> option is added to control how the JITServer AOT cache feature interacts with the local cache at JITServer client VMs.</td>
<td valign="top">All versions (Linux x86, Linux on POWER (Little Endian), and Linux on IBM Z)</td>
<td valign="top">Earlier, to use the JITServer AOT cache feature, the client VM had to use a shared class cache with some empty space and write permissions. From this release onwards, the default behavior of the client when it uses the JITServer AOT cache is to bypass its local shared classes cache (if one is set up) during JITServer AOT cache compilations. You can disable this feature with the <tt>-XX:-JITServerAOTCacheIgnoreLocalSCC</tt> option.
</td>
</tr>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/18217">#18217</a></td>
<td valign="top">The <tt>-XdynamicHeapAdjustment</tt> option is added to create a single image file and restore it on various nodes with different memory limits.</td>
<td valign="top">OpenJDK 11 and later (Linux)</td>
<td valign="top">By default, if a checkpoint is taken in a container with no memory limits and then restored in a container with memory limits, the restored VM instance does not detect the memory limits. The new option <tt>-XdynamicHeapAdjustment</tt> automatically adjusts the maximum Java heap size <tt>-Xmx</tt> and minimum Java heap size <tt>-Xms</tt> values such that they are within the physical memory limitations on the system.
</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/18272">#18272</a></td>
<td valign="top">A new Data Access Accelerator (DAA) library API <tt>com/ibm/dataaccess/ExternalDecimal.checkExternalDecimal</tt> is added to verify the validity of the sign and digits of a given external decimal input before operating on the data.</td>
<td valign="top">All versions</td>
<td valign="top">The new DAA library API <tt>com/ibm/dataaccess/ExternalDecimal.checkExternalDecimal</tt> supports external decimals with all four sign configurations: sign embedded trailing, sign embedded leading, sign separate trailing, and sign separate leading. It also accommodates sign embedded trailing with spaces.
</td>
</tr>

</tbody>
</table>

## Known issues

The v0.46.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>

<tbody>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/19833">#19833</a></td>
<td valign="top">Class comparison for the shared cache might not detect the removal of method access modifiers. For example, a change of a method from public to package-private.</td>
<td valign="top">All</td>
<td valign="top">If you ran your application with the <tt>-XX:+ShareOrphans</tt> option, then recompiled classes after removing the method access modifier and reran with the <tt>-XX:+ShareOrphans</tt> option, the old version of the class might still be used.</td>
<td valign="top">Remove the <tt>-XX:+ShareOrphans</tt> option and rerun.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/19833">#19833</a></td>
<td valign="top"><tt>java.lang.StackTraceElement.getClassLoaderName()</tt> might return null for classes that are stored in the shared cache.</td>
<td valign="top">All</td>
<td valign="top">When the <tt>-XX:+ShareOrphans</tt> option is specified, <tt>java.lang.StackTraceElement.getClassLoaderName()</tt> might incorrectly return null on a class loader that has a name. If a class loader has a name, the correct behavior is to return the name.</td>
<td valign="top">Remove the <tt>-XX:+ShareOrphans</tt> option and rerun.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15011">#15011</a></td>
<td valign="top">The default stack size for the main thread is a smaller platform-dependent value.</td>
<td valign="top">All</td>
<td valign="top">The main thread stack size was 1 MB in releases before 0.32. In the 0.32 release and later it was modified to a smaller
platform-dependent value, the same value as the <tt>-Xmso</tt> setting. The 0.33 release increased the default <tt>-Xmso</tt> stack size
on x64 platforms, but builds with OpenJDK 17 and later also require more stack space to run. These changes might result in a
<tt>java.lang.StackOverflowError: operating system stack overflow</tt>.</td>
<td valign="top">Use <tt>-Xmso</tt> to set the default stack size. See the default value by using <tt>-verbose:sizes</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14803">#14803</a></td>
<td valign="top">Using the <tt>-XX:+ShowHiddenFrames</tt> option in an OpenJ9 release that is built with OpenJDK 18 and later causes errors.</td>
<td valign="top">All platforms</td>
<td valign="top">Wrong exception might be thrown when using the Reflection API.</td>
<td valign="top">Avoid using the <tt>-XX:+ShowHiddenFrames</tt> option with OpenJDK 18 and later.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13767">#13767</a></td>
<td valign="top">Compressed references mode is not available.</td>
<td valign="top">Apple silicon macOS</td>
<td valign="top">You can use only the large heap (non-compressed references) mode.</td>
<td valign="top">None</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for 0.46.0 release is available at [Eclipse OpenJ9 v0.46.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.46.0).
