<!--
* Copyright (c) 2025 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.51.0 release notes

These release notes support the [Eclipse OpenJ9&trade; 0.51.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.51.0/plan).

## Supported environments

OpenJ9 release 0.51.0 supports OpenJDK 8, 11, 17, and 21.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.51.0. Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.51/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr>
<td valign="top">
<a href="https://github.com/eclipse-openj9/openj9/pull/21320">#21320<br>
<a href="https://github.com/eclipse-openj9/openj9/pull/21357">#21357<br>
<a href="https://github.com/eclipse-openj9/openj9/pull/21452">#21452<br>
<a href="https://github.com/eclipse-openj9/openj9/issues/21189">#21189<br>
</td>
<td valign="top">OpenJDK system properties are used to initialize some system properties.</td>
<td valign="top">All versions</td>
<td valign="top">A number of OpenJDK system properties are set, some of which were not set before.
Of note, on Windows the console encoding properties reflect the console charset.
The default locale may be different from previous Semeru versions, and is now consistent with OpenJDK behavior.
In particular on macOS the default locale reflects the control panel settings rather than environment variable settings.
The locale script is set when available.
Another example is that in all the JDK versions except for the IBM Java 8, OpenJDK is now used to initialize the <tt>java.io.tmpdir</tt> system property. Earlier, the <tt>TMPDIR=<directory></tt> environment variable set the value of the <tt>java.io.tmpdir</tt> property. Because of this change, even if the <tt>TMPDIR=<directory></tt> variable is specified, it is ignored when setting the <tt>java.io.tmpdir</tt> property value.
</td>
</tr>

<tr>
<td valign="top">N/A </td>
<td valign="top">Ubuntu 20.04 is removed from the list of supported platforms.</td>
<td valign="top">All versions (Ubuntu 20.04) </td>
<td valign="top">Ubuntu 22.04 is the new minimum operating system level.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9-docs/issues/1498">#1498</a></td>
<td valign="top">XL C++ Runtime 16.1.0.10 or later required for AIX OpenJ9 builds</td>
<td valign="top">All versions (AIX)</td>
<td valign="top">Earlier, XL C++ Runtime 16.1.0.7 or later was required for AIX OpenJ9 builds. Now, AIX OpenJ9 builds require version 16.1.0.10 or later of the IBM XL C++ Runtime.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/16416">#16416</a>, <a href="https://github.com/eclipse-openj9/openj9/issues/20662">#20662</a></td>
<td valign="top">A new parameter <tt>maxstringlength</tt> is added to the <tt>-Xtrace</tt> option to specify the length of the string arguments and return values that are printed in trace output.</td>
<td valign="top">All versions</td>
<td valign="top">When you use the method tracing options, such as <tt>-Xtrace:methods={java/lang/String.concat'()'}</tt>, the argument is passed to the function as a string and the value is returned as a string. Earlier, you could not capture the contents of the string arguments and return values, only the address of the string object was printed. Now, both the actual strings as well as the addresses can be printed and with the new parameter, you can specify the length of the strings that are printed.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/ibmruntimes/openj9-openjdk-jdk/pull/920">#920</a></td>
<td valign="top">Support for JDK Flight Recorder (JFR) in the VM is provided as a technical preview for OpenJDK 11 and later running on all platforms.</td>
<td valign="top">OpenJDK 11 and later (All platforms)</td>
<td valign="top">Earlier, support was provided for JFR that was available for OpenJDK 11 and later running on Linux&reg; x86 and Linux on AArch64 only.</td>

</tr>
</tbody>
</table>

## Known issues

The v0.51.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>

<tbody>
<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15011">#15011</a></td>
<td valign="top">The default stack size for the main thread is a smaller platform-dependent value.</td>
<td valign="top">All</td>
<td valign="top">The main thread stack size was 1 MB in releases before 0.32. In the 0.32 release and later it was modified to a smaller
platform-dependent value, the same value as the <tt>-Xmso</tt> setting. The 0.33 release increased the default <tt>-Xmso</tt> stack size
on x64 platforms, but builds with OpenJDK 17 and later also require more stack space to run. These changes might result in a
<tt>java.lang.StackOverflowError: operating system stack overflow</tt>.</td>
<td valign="top">Use <tt>-Xmso</tt> to set the default stack size. See the default value by using <tt>-verbose:sizes</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13767">#13767</a></td>
<td valign="top">Compressed references mode is not available.</td>
<td valign="top">Apple silicon macOS</td>
<td valign="top">You can use only the large heap (non-compressed references) mode.</td>
<td valign="top">None</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14803">#14803</a></td>
<td valign="top">Using the <tt>-XX:+ShowHiddenFrames</tt> option in an OpenJ9 release that is built with OpenJDK 18 and later causes errors.</td>
<td valign="top">All platforms</td>
<td valign="top">Wrong exception might be thrown when using the Reflection API.</td>
<td valign="top">Avoid using the <tt>-XX:+ShowHiddenFrames</tt> option with OpenJDK 18 and later.</td>
</tr>

<tr>
<td valign="top">N/A </td>
<td valign="top">JVM fails to load AOT compiled code from portable shared class cache created on IBM z17.</td>
<td valign="top">Linux on IBM Z®</td>
<td valign="top">When a docker container image with Eclipse OpenJ9 is created
on a system running on IBM z17 hardware and deployed on older IBM Z hardware,
the JVM will fail to validate AOT-compiled code, which would cause the JVM to
start JIT compiling methods. This issue can impact increased CPU usage driven
by JIT compilation activities and/or slow application start-up. Outside of the
Docker container, if portable shared class cache is enabled explicitly by using
the <tt>-XX:+PortableSharedCache</tt> option, a similar issue can be seen when
such shared class cache is populated with portable AOT code on IBM z17 hardware
and used on older IBM Z hardware.</td>
<td valign="top">If you are deploying application containers using Eclipse
OpenJ9 on IBM Z platform, do not build your application container image on a
system running on IBM z17 hardware. Similarly, in case of using Portable Shared
Class Cache explicitly by supplying the JVM option
<tt>-XX:+PortableSharedCache</tt>, do not prime the shared class cache on a
system running on IBM z17 hardware and run on an older IBM Z platform.</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for 0.51.0 release is available at [Eclipse OpenJ9 v0.51.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.51.0).
