/*[INCLUDE-IF Sidecar18-SE]*/
/*
 * Copyright IBM Corp. and others 2007
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.dtfj.javacore.builder;

import com.ibm.dtfj.image.ImageSection;

/**
 * Factory for building an com.ibm.dtfj.image.ImageAddressSpace.
 * An ImageAddressSpace factory contains various ImageProcess factories,
 * each pertaining to a specific ImageProcess and distinguished by unique ids.
 * In most cases, there will only be one ImageProcess factory associated with
 * one ImageAddressSpace factory.
 *
 */
public interface IImageAddressSpaceBuilder {
	/**
	 * Returns the current image process builder (factory) associated
	 * with the image address space factory. Usually, there is only
	 * one image process, thus one image process factory. In the event
	 * that multiple image processes exist for one image address space,
	 * the current image process factory may be the last image process factory
	 * generated by the image address space factory.
	 * @return current (usually the only) ImageProcess factory. Value must not be null.
	 */
	public IImageProcessBuilder getCurrentImageProcessBuilder();
	/**
	 *
	 * @param builderID
	 *
	 */

	/**
	 * In multiple image process scenarios, each image process is associated with
	 * it's own image process factory, and the latter are distinguished by unique
	 * id values.
	 * @param builderID unique id of the image process factory
	 * @return image process factory if found, or null
	 */
	public IImageProcessBuilder getImageProcessBuilder(String builderID);

	/**
	 * To associate a new image process to the image address space being built
	 * by this image address space factory, use this interface to create a new
	 * image process factory for the aforementioned image process. At least one
	 * image process must exist for an image address space, therefore consequently,
	 * at least one image process factory must be created for each image address space factory.
	 * @param id unique id for image process factory to be added to the image address space factory
	 * @return generated image process factory
	 * @throws BuilderFailureException if error generating image process factory
	 */
	public IImageProcessBuilder generateImageProcessBuilder(String id) throws BuilderFailureException;

	/**
	 * Create a new image section with the given name, base address and size
	 * and add it to the list in the ImageAddressSpace.
	 */
	public ImageSection addImageSection(String name, long base, long size);
}
