/*[INCLUDE-IF Sidecar18-SE]*/
/*
 * Copyright IBM Corp. and others 2012
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.jvm.dtfjview.tools.utils;

/**
 * This is an interface to be used by pre-match handlers.
 * <p>
 * @author Manqing Li, IBM.
 *
 */
public interface IPrematchHandle {

	/**
	 * This is for the prematch handle to process the incoming string (such
	 * as cache it, trim it, etc).
	 * <p>
	 * @param s
	 */
	public void process(String s);

	/**
	 * This is to release the string.  Note, depending on the actual
	 * implementation of the pre-match handle, the released string
	 * can have multiple lines.
	 * <p>
	 * @return a String object.
	 */
	public String release();
}
