/*[INCLUDE-IF SharedClasses]*/
package com.ibm.oti.shared;

/*
 * Copyright IBM Corp. and others 1998
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/**
 * SharedClassFilter allows users of a Helper API to filter which classes are found and stored in the cache.
 * The user should provide a class that implements the interface in which the functions return <code>true</code> or <code>false</code>,
 * and then pass an instance of this class to setSharingFilter() in a shared class helper.
 *
 * @see SharedClassURLHelper
 * @see SharedClassTokenHelper
 * @see SharedClassURLClasspathHelper
 */
public interface SharedClassFilter {

	/**
	 * Tests if a specified class should be stored in the shared class cache
	 *
	 * @param className		String.
	 *				The fully-qualified name of the class, with the package and class names separated by '.'
	 * @return boolean.
	 *				True if the class should be stored in the class cache, false otherwise.
	 */
	public boolean acceptStore(String className);

	/**
	 * Tests if the helper should try to find a specified class in the shared class cache
	 *
	 * @param className		String.
	 *				The fully-qualified name of the class, with the package and class names separated by '.'
	 * @return boolean.
	 *				True if the helper should try to find the class, false otherwise
	 */
	public boolean acceptFind(String className);
}
