/*******************************************************************************
 * Copyright IBM Corp. and others 1998
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 *******************************************************************************/

#include "jni.h"
#include "jcl.h"
#include "jclglob.h"
#include "jclprots.h"
#include "jcl_internal.h"

#include "VMHelpers.hpp"
#include "AtomicSupport.hpp"

extern "C" {

jobject JNICALL
Java_java_lang_J9VMInternals_getStackTrace(JNIEnv *env, jclass recv, jobject throwable, jboolean pruneConstructors)
{
#if JAVA_SPEC_VERSION >= 19
	/* throwable can only be null for a virtual thread during mount and unmount transition. */
	if (NULL == throwable) {
		return NULL;
	}
#endif /* JAVA_SPEC_VERSION >= 19 */

	J9VMThread *currentThread = (J9VMThread *)env;
	J9JavaVM *vm = currentThread->javaVM;
	J9InternalVMFunctions *vmFuncs = vm->internalVMFunctions;

	vmFuncs->internalEnterVMFromJNI(currentThread);
	j9object_t traceObject = (j9object_t)getStackTrace(currentThread, (j9object_t *)throwable, (UDATA)pruneConstructors);
	jobject result = vmFuncs->j9jni_createLocalRef(env, traceObject);
	vmFuncs->internalExitVMToJNI(currentThread);
	return result;
}


}
