/*
 * Copyright IBM Corp. and others 2001
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package jit.test.jitt.exceptions;

import jit.test.jitt.*;
import org.testng.annotations.Test;
import org.testng.Assert;

@Test(groups = { "level.sanity","component.jit" })
public class InterpJitException extends jit.test.jitt.Test {

	// jit method
	static void tstfoo(boolean throwNow) throws Exception {
		if (throwNow)
			throw new Exception();
	}

	// interpreted method
	static void tstmoo(boolean throwNow) {
		try {
			if (throwNow)
				tstfoo(throwNow);
			else
				return;
		} catch (Exception e) {
			return;
		}
		Assert.fail("Failed to catch exception");
	}

	@Test
	public void testInterpJitException() {

		try {
			tstfoo(true);
		} catch (Exception e) {
		}

		try {
			for (int i = 0; i < sJitThreshold; i++)
				tstfoo(false);
		} catch (Exception e) {
		}
		tstmoo(true);
	}

}
