/*
 * Copyright IBM Corp. and others 2001
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

package com.ibm.j9.recreateclass.testclasses;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodHandles.Lookup;

/**
 * Class that provides bootstrap methods used by invokedynamic instruction generated by InvokeDynamicTestGenerator.
 * Note that this class is only provided for sake of completeness, and is not used as such.
 * 
 * @author ashutosh
 */
public class BootstrapMethods {
	
	public static String concatStrings(String s1, String s2) {
		return s1 + s2;
	}
	
	public static int addIntegers(int i1, int i2) {
		return i1 + i2;
	}
	
	public static CallSite bootstrapConcatStrings(Lookup caller, String name,
			MethodType type) throws Throwable {
		MethodHandles.Lookup lookup = MethodHandles.lookup();
		Class<?> thisClass = lookup.lookupClass();
		MethodHandle concatStrings = lookup.findStatic(thisClass,
				"concatStrings", type);
		return new ConstantCallSite(concatStrings);
	}
	
	public static CallSite bootstrapAddInts(Lookup caller, String name,
			MethodType type) throws Throwable {
		MethodHandles.Lookup lookup = MethodHandles.lookup();
		Class<?> thisClass = lookup.lookupClass();
		MethodHandle addIntegers = lookup.findStatic(thisClass,
				"addIntegers", type);
		return new ConstantCallSite(addIntegers);
	}
	
	public static CallSite bootstrapGetStringConstant(Lookup caller, String name, MethodType type, String s1) throws Throwable {
		return new ConstantCallSite(MethodHandles.constant(String.class, s1));
	}
}
