/*
 * Copyright IBM Corp. and others 2018
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.jvmti.tests.setNativeMethodPrefix;

import com.ibm.jvmti.tests.util.Util;

public class snmp001 {

	public static native boolean setPrefix();
	public static void nat() {
		$$J9$$nat();
	}
	public static native void $$J9$$nat();

	public boolean testPrefixWithDispose() throws Throwable {
		if (!setPrefix()) {
			System.out.println("error in prefixing native");
			return false;
		}
		try {
			nat();
			System.out.println("found prefixed native");			
		} catch(UnsatisfiedLinkError e) {
			System.out.println("unable to find prefixed native");
			return false;
		}
		return true;
	}

	public String helpPrefixWithDispose() {
		return "Tests setting a native method prefix and disposing a subsequent environment";
	}
}
