/*******************************************************************************
 * Copyright IBM Corp. and others 2015
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 *******************************************************************************/

/**
 * @file
 * @ingroup Port
 * @brief shared library
 */
#include <string.h>
#include "omrport.h"
#include "omrgetjobid.h"

#define JOBID_STRING "%jobid"
#define JOBID_STRING_LENGTH sizeof(JOBID_STRING)

/* Generic version of omrgetjobid() */
uintptr_t
omrget_jobid(struct OMRPortLibrary *portLibrary, char *jobid, uintptr_t length)
{
	/* Check that caller provided enough space for the string */
	if ((NULL == jobid) || (length < JOBID_STRING_LENGTH)) {
		return JOBID_STRING_LENGTH;
	}

	/* Default behaviour for platforms other than zOS, simply return the job ID string token */
	strcpy(jobid, JOBID_STRING);

	return 0;
}
