<!--
Copyright IBM Corp. and others 2018

This program and the accompanying materials are made available under
the terms of the Eclipse Public License 2.0 which accompanies this
distribution and is available at https://www.eclipse.org/legal/epl-2.0/
or the Apache License, Version 2.0 which accompanies this distribution and
is available at https://www.apache.org/licenses/LICENSE-2.0.

This Source Code may also be made available under the following
Secondary Licenses when the conditions for such availability set
forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
General Public License, version 2 with the GNU Classpath
Exception [1] and GNU General Public License, version 2 with the
OpenJDK Assembly Exception [2].

[1] https://www.gnu.org/software/classpath/license.html
[2] https://openjdk.org/legal/assembly-exception.html

SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# CMake Getting Started / FAQ

## How to build with CMake

The CMake build system is designed to provide as seamless a transition as is possible.
As such, the normal OpenJ9 [build instructions](https://www.eclipse.org/openj9/oj9_build.html)
can be followed with the following modifications:

- Ensure that CMake version 3.5 or greater is installed
  - The docker images will already have this provided
  - Windows users need to have the Cygwin CMake package via the Cygwin installer, rather than downloading
    the native windows version from the CMake website.

:pencil: For more CMake info see [OMR CMake documentation](https://github.com/eclipse-omr/omr/blob/master/doc/BuildingWithCMake.md)

## FAQ

### Why are only some targets installed via `install()`?
Generally only shared libraries / executables are installed. Static libraries are
not since they are considered temporary artifacts generated by the build.

:pencil: Here `install()` isn't being used in its normal sense. Here it's used
just to update the `rpath` (on applicable platforms) and to move the binary
to the corresponding source directory. We do this purely for compatability with
existing build infrastructure that expects the binaries to be laid out as they
would be under a `makefile` driven build.
