<!--
* Copyright IBM Corp. and others 2020
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.22.0 release notes

These release notes support the [Eclipse OpenJ9 0.22.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.22.0/plan).

## Binaries and supported environments

OpenJ9 release 0.22.0 supports OpenJDK 15.

Binaries are available at the AdoptOpenJDK project:

- [OpenJDK 15 with OpenJ9](https://adoptopenjdk.net/archive.html?variant=openjdk15&jvmVariant=openj9)

All builds are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).


## Notable changes in this release

The following table covers notable changes in v0.22.0. Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.22/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr><td valign="top">
<a href="https://github.com/eclipse-openj9/openj9/pull/9731">#9731</a>,
<a href="https://github.com/eclipse-openj9/openj9/pull/9993">#9993</a>,
<a href="https://github.com/eclipse-omr/omr/pull/5436">#5436</a>,
<a href="https://github.com/eclipse-openj9/openj9/pull/10305">#10305</a></td>
<td valign="top">New <tt>-XX:[+|-]PortableSharedCache</tt> option added</td>
<td valign="top">All versions</td>
<td valign="top">This option enables AOT compiled code to be generated based on a chosen set of processor features that maximizes its portability across machines. It is currently supported only on x86. The feature is turned on by default in Docker containers and can be disabled with <tt>-XX:-PortableSharedCache</tt>.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/10217">#10217</a></td>
<td valign="top">Methods in <tt>com.ibm.lang.management.MemoryMXBean</tt> deprecated and replaced</td>
<td valign="top">All versions</td>
<td valign="top">The methods <tt>com.ibm.lang.management.MemoryMXBean.getGCMasterThreadCpuUsed()</tt> and <tt>com.ibm.lang.management.MemoryMXBean.getGCSlaveThreadsCpuUsed()</tt> are deprecated for removal in Java 16. The recommended methods to be used are <tt>com.ibm.lang.management.MemoryMXBean.getGCMainThreadCpuUsed()</tt> and <tt>com.ibm.lang.management.MemoryMXBean.getGCWorkerThreadsCpuUsed()</tt> respectively.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/9489">#9489</a></td>
<td valign="top"><tt>java.lang.System.mapLibraryName()</tt> string suffix</tt></td>
<td valign="top">From OpenJDK15, on AIX&reg;</td>
<td valign="top"><tt>java.lang.System.mapLibraryName(libname)</tt> returns a representation of a native library in a platform-specific string with a <tt>.so</tt> suffix. (Output from versions prior to OpenJDK15 has a <tt>.a</tt> suffix.)</td>
</tr>


</table>


## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.22.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.22.0).
