<!--
* Copyright IBM Corp. and others 2021
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.29.1 release notes

These release notes support the [Eclipse OpenJ9 0.29.1 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.29.1/plan).

## Supported environments

OpenJ9 release 0.29.1 supports OpenJDK 17.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.29.1. See also the [v0.29 release notes](https://github.com/eclipse-openj9/openj9/blob/master/doc/release-notes/0.29/0.29.md).
Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.29.1/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr><td valign="top">N/A</td>
<td valign="top">AArch64 Linux is now a fully supported, production-ready target</td>
<td valign="top">AArch64 Linux, all JDK versions</td>
<td valign="top">The remaining features, performance items, and bug fixes are implemented, making AArch64 Linux a production-ready target.</td>
</tr>

<tr><td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/13492">#13492</a></td>
<td valign="top">JITServer technology is now a supported feature for Linux on x86-64 and Power</td>
<td valign="top">OpenJDK 17 (Linux on x86-64, Linux on Power)</td>
<td valign="top">JITServer decouples the JIT compiler from the OpenJ9 VM, freeing up CPU and memory for an application. JITServer then runs in its own process, either locally or on a remote machine, where resources can be separately managed.</td>
</tr>

</tbody>
</table>

## Known Issues

The v0.29.1 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr valign="bottom">
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>
<tbody>

</tbody>
</table>

## Other changes

A full commit history for this release is available at [Eclipse OpenJ9 v0.29.1](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.29.1).
