<!--
* Copyright (c) 2025 IBM Corp. and others
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.49.0 release notes

These release notes support the [Eclipse OpenJ9&trade; 0.49.0 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.49.0/plan).

## Supported environments

OpenJ9 release 0.49.0 supports OpenJDK 8, 11, 17, 21, and 23.

All releases are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests provided by Adoptium.

To learn more about support for OpenJ9 releases, including OpenJDK levels and platform support, see [Supported environments](https://eclipse.org/openj9/docs/openj9_support/index.html).

## Notable changes in this release

The following table covers notable changes in v0.49.0. Further information about these changes can be found in the [user documentation](https://www.eclipse.org/openj9/docs/version0.49/).

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1"><thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
</tr>
</thead>
<tbody>

<tr>
<td valign="top">N/A</td>
<td valign="top">macOS&reg; 12 is out of support</td>
<td valign="top">All versions (macOS 12)</td>
<td valign="top">macOS 13 is the new minimum operating system level.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/20029">#20029</a></td>
<td valign="top">The shared classes cache generation number is incremented.</td>
<td valign="top">All versions</td>
<td valign="top">The increment in the shared classes cache generation number causes the VM to create a new shared classes cache, rather than re-creating or reusing an existing cache. To save space, all existing shared caches should be removed unless they are in use by an earlier release.
The shared classes cache generation number is modified because of a change in the format of ROMClasses that are stored in the shared classes cache. A new flag <tt>J9AccClassIsShared</tt> is added to ROMClasses to indicate whether a ROMClass was loaded from a shared classes cache or from a VM.
</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/20366">#20366</a></td>
<td valign="top">A new shared classes cache suboption <tt>-Xshareclasses:extraStartupHints</tt> is added.</td>
<td valign="top">All versions</td>
<td valign="top">By default, you can add up to 64 startup hints only in a shared cache. You can use the <tt>-Xshareclasses:extraStartupHints=&ltnumber&gt</tt> option to adjust the number of startup hints that can be stored in a shared cache in addition to the default number.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/19872">#19872</a></td>
<td valign="top"><tt>subAllocator</tt> related <tt>-Xgc</tt> options are added to control the compressed reference allocation.</td>
<td valign="top">All versions</td>
<td valign="top">The VM can use compressed references to decrease the size of Java objects and make better use of the available space in the Java heap. You can now control the compressed reference allocation with the following options:

 - <tt>-Xgc:suballocatorCommitSize=\<size></tt>
 - <tt>-Xgc:suballocatorIncrementSize=\<size></tt>
 - <tt>-Xgc:suballocatorInitialSize=\<size></tt>
 - <tt>-Xgc:suballocatorQuickAllocDisable</tt>
 - <tt>-Xgc:suballocatorQuickAllocEnable</tt></td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/pull/20854">#20854</a></td>
<td valign="top">Support for JDK Flight Recorder (JFR) in the VM is provided as a technical preview and a new option <tt>-XX:[+|-]FlightRecorder</tt> is added to enable or disable JFR.</td>
<td valign="top">OpenJDK 11 and later (Linux&reg; on x86 and Linux on AArch64)</td>
<td valign="top">JFR is enabled by default and you can trigger the profile and diagnostic recording with the <tt>jcmd</tt> tool. You can disable JFR with the <tt>-XX:-FlightRecorder</tt> option. </td>
</tr>

</tbody>
</table>

## Known issues

The v0.49.0 release contains the following known issues and limitations:

<table cellpadding="4" cellspacing="0" summary="" width="100%" rules="all" frame="border" border="1">
<thead align="left">
<tr>
<th valign="bottom">Issue number</th>
<th valign="bottom">Description</th>
<th valign="bottom">Version / Platform</th>
<th valign="bottom">Impact</th>
<th valign="bottom">Workaround</th>
</tr>
</thead>

<tbody>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/15011">#15011</a></td>
<td valign="top">The default stack size for the main thread is a smaller platform-dependent value.</td>
<td valign="top">All</td>
<td valign="top">The main thread stack size was 1 MB in releases before 0.32. In the 0.32 release and later it was modified to a smaller
platform-dependent value, the same value as the <tt>-Xmso</tt> setting. The 0.33 release increased the default <tt>-Xmso</tt> stack size
on x64 platforms, but builds with OpenJDK 17 and later also require more stack space to run. These changes might result in a
<tt>java.lang.StackOverflowError: operating system stack overflow</tt>.</td>
<td valign="top">Use <tt>-Xmso</tt> to set the default stack size. See the default value by using <tt>-verbose:sizes</tt>.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/14803">#14803</a></td>
<td valign="top">Using the <tt>-XX:+ShowHiddenFrames</tt> option in an OpenJ9 release that is built with OpenJDK 18 and later causes errors.</td>
<td valign="top">All platforms</td>
<td valign="top">Wrong exception might be thrown when using the Reflection API.</td>
<td valign="top">Avoid using the <tt>-XX:+ShowHiddenFrames</tt> option with OpenJDK 18 and later.</td>
</tr>

<tr>
<td valign="top"><a href="https://github.com/eclipse-openj9/openj9/issues/13767">#13767</a></td>
<td valign="top">Compressed references mode is not available.</td>
<td valign="top">Apple silicon macOS</td>
<td valign="top">You can use only the large heap (non-compressed references) mode.</td>
<td valign="top">None</td>
</tr>

</tbody>
</table>

## Other changes

A full commit history for 0.49.0 release is available at [Eclipse OpenJ9 v0.49.0](https://github.com/eclipse-openj9/openj9/releases/tag/openj9-0.49.0).
