<!--
* Copyright IBM Corp. and others 2017
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which accompanies this distribution and is available at
* https://www.eclipse.org/legal/epl-2.0/ or the Apache
* License, Version 2.0 which accompanies this distribution and
* is available at https://www.apache.org/licenses/LICENSE-2.0.
*
* This Source Code may also be made available under the
* following Secondary Licenses when the conditions for such
* availability set forth in the Eclipse Public License, v. 2.0
* are satisfied: GNU General Public License, version 2 with
* the GNU Classpath Exception [1] and GNU General Public
* License, version 2 with the OpenJDK Assembly Exception [2].
*
* [1] https://www.gnu.org/software/classpath/license.html
* [2] https://openjdk.org/legal/assembly-exception.html
*
* SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
-->

# Eclipse OpenJ9 version 0.8 release notes

These release notes support the [Eclipse OpenJ9 release plan](https://projects.eclipse.org/projects/technology.openj9/releases/0.8/plan).


## Supported platforms

OpenJDK Version 8 binaries containing the Eclipse OpenJ9 virtual machine are supported with this release.

These binaries are available from the [AdoptOpenJDK community](https://adoptopenjdk.net/?variant=openjdk8-openj9).
Builds are tested against the OpenJ9 functional verification (FV) test suite, the OpenJDK test suites, and additional tests at AdoptOpenJDK.

The following platforms are available:

|Operating system            | Platform architecture                 | Comments                                     |
|----------------------------|---------------------------------------|----------------------------------------------|
|Linux<sup>&trade;</sup>     | x86, IBM Power, IBM Z<sup>&reg;</sup> | Windows subsystem for Linux is not supported |
|AIX<sup>&reg;</sup>         | IBM Power<sup>&reg;</sup>             | Untested                                     |
|Windows<sup>&trade;</sup>   | x86                                   | Untested                                     |


## Known Issues

The v0.8 release contains the following known issues and limitations:

#### Direct dump reader
[Issue #378](https://github.com/eclipse-openj9/openj9/issues/378):
The direct dump reader is currently not working, which has an impact on diagnosing problems with the VM, Garbage Collector, and the JIT. For example, [issue #968](https://github.com/eclipse-openj9/openj9/issues/968).

#### Signal handling
[Issue #54](https://github.com/eclipse-openj9/openj9/issues/54): Some signals are not being handled correctly by the VM. In particular, for CTRL-C or other signals that shutdown the VM, the shutdown hooks are not running. See [Issue #378](https://github.com/eclipse-openj9/openj9/issues/378)

#### Large Java heaps
[Issue #479](https://github.com/eclipse-openj9/openj9/issues/479): The binaries available at AdoptOpenJDK are built only with the compressed references VM, which does not support Java<sup>&trade;</sup> heaps larger
than 57 GB (or ~62 GB with command line options). When builds that contain the non-compressed references VM are available, this limitation will be removed. If
you want to build a non-compressed references VM yourself, you can do so now by following our [detailed build instructions](https://github.com/eclipse-openj9/openj9/blob/master/buildenv/Build_Instructions_V8.md).

#### Graphics Processor Unit (GPU) support
GPU acceleration with `java.util.Arrays.sort()` is not supported, although `com.ibm.gpu.Maths` can be used directly.

#### Functional verification tests
The following issues relate to test failures:

- [#238](https://github.com/eclipse-openj9/openj9/issues/238), [#244](https://github.com/eclipse-openj9/openj9/issues/244), [#362](https://github.com/eclipse-openj9/openj9/issues/362), [#366](https://github.com/eclipse-openj9/openj9/issues/366), [#480](https://github.com/eclipse-openj9/openj9/issues/480), [#858](https://github.com/eclipse-openj9/openj9/issues/858), [#968](https://github.com/eclipse-openj9/openj9/issues/968), [#1127](https://github.com/eclipse-openj9/openj9/issues/1127), [#1128](https://github.com/eclipse-openj9/openj9/issues/1128), [#1129](https://github.com/eclipse-openj9/openj9/issues/1129), [#1130](https://github.com/eclipse-openj9/openj9/issues/1130), [#1131](https://github.com/eclipse-openj9/openj9/issues/1131), [#1144](https://github.com/eclipse-openj9/openj9/issues/1144), [#1151](https://github.com/eclipse-openj9/openj9/issues/1151), [#1203](https://github.com/eclipse-openj9/openj9/issues/1203), [#1204](https://github.com/eclipse-openj9/openj9/issues/1204), [#1205](https://github.com/eclipse-openj9/openj9/issues/1205), [#1207](https://github.com/eclipse-openj9/openj9/issues/1207), [#1209](https://github.com/eclipse-openj9/openj9/issues/1209), [#1212](https://github.com/eclipse-openj9/openj9/issues/1212), and [#1244](https://github.com/eclipse-openj9/openj9/issues/1244).

Because some tests are not yet enabled, functional problems might not be exposed. In addition, some IBM authored functional verification testing is not yet contributed to Eclipse, such as issue  [#724](https://github.com/eclipse-openj9/openj9/issues/724).

#### API documentation

Some OpenJ9 extensions are missing, see [issue #897](https://github.com/eclipse-openj9/openj9/issues/897).

Some OpenJ9 extensions are unsupported, see [issue #898](https://github.com/eclipse-openj9/openj9/issues/898).

#### Shared libraries

[Issue #17](https://github.com/ibmruntimes/openj9-openjdk-jdk8/issues/17): OpenJ9 builds contain extra shared libraries. Some of these libraries are not needed and others are used only for test purposes.
