/*******************************************************************************
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 *******************************************************************************/
#ifndef j9portpg_h
#define j9portpg_h
/* @ddr_namespace: map_to_type=J9PortpgConstants */
typedef struct STFLEFacilities {
	uint64_t dw1;
	uint64_t dw2;
	uint64_t dw3;
} STFLEFacilities;

typedef struct J9STFLECache {
	uintptr_t lastDoubleWord;
	STFLEFacilities facilities;
} J9STFLECache;

typedef struct J9PortPlatformGlobals {
#if defined(AIXPPC)
	int pageProtectionPossible;
#endif
#if !(defined(RS6000) || defined (LINUXPPC) || defined (PPC))
	int si_l1DCacheLineSize;
#endif
	J9STFLECache stfleCache;
} J9PortPlatformGlobals;

#if !(defined(RS6000) || defined (LINUXPPC) || defined (PPC))
#define PPG_sysL1DCacheLineSize (portLibrary->portGlobals->platformGlobals.si_l1DCacheLineSize)
#endif
#if defined(AIXPPC)
#define PPG_pageProtectionPossible (portLibrary->portGlobals->platformGlobals.pageProtectionPossible)
#define PAGE_PROTECTION_AVAILABLE 0
#define PAGE_PROTECTION_NOTAVAILABLE 1
#define PAGE_PROTECTION_NOTCHECKED 2
#endif

#define PPG_stfleCache (portLibrary->portGlobals->platformGlobals.stfleCache)

#endif /* j9portpg_h */

