/*
 * Copyright IBM Corp. and others 1998
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package org.openj9.test.java.lang;

import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;
import org.testng.annotations.BeforeMethod;
import org.testng.AssertJUnit;

@Test(groups = { "level.sanity" })
public class Test_ClassCastException {

	/**
	 * @tests java.lang.ClassCastException#ClassCastException()
	 */
	@Test
	public void test_Constructor() {
		// Test for method java.lang.ClassCastException()
		try {
			try {
				String z = (String)new Object();
				if (z == null)
					; //use z to avoid a warning msg
			} catch (ClassCastException e) {
				return;
			}
			AssertJUnit.assertTrue("Failed to generate Exception", false);
		} catch (Exception e) {
			AssertJUnit.assertTrue("Exception during test", false);
		}
	}

	/**
	 * @tests java.lang.ClassCastException#ClassCastException(java.lang.String)
	 */
	@Test
	public void test_Constructor2() {
		// Test for method java.lang.ClassCastException(java.lang.String)
		try {
			try {
				String z = (String)new Object();
				if (z == null)
					; //use z to avoid a warning msg
			} catch (ClassCastException e) {
				return;
			}
			AssertJUnit.assertTrue("Failed to generate Exception", false);
		} catch (Exception e) {
			AssertJUnit.assertTrue("Exception during test", false);
		}
	}

	/**
	 * Sets up the fixture, for example, open a network connection.
	 * This method is called before a test is executed.
	 */
	@BeforeMethod
	protected void setUp() {
	}

	/**
	 * Tears down the fixture, for example, close a network connection.
	 * This method is called after a test is executed.
	 */
	@AfterMethod
	protected void tearDown() {
	}

}
