/*
 * Copyright IBM Corp. and others 2001
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package j9vm.test.clone;

import java.util.Hashtable;

public class SynchronizedCloneTest {

	public void run() {
		try {
			Hashtable originalObject = new Hashtable();
			synchronized (originalObject) {
				Hashtable clonedHashtable = (Hashtable) originalObject.clone();
				clonedHashtable.notify();
			}
		} catch(IllegalMonitorStateException e) {
			return;
		}
		catch(Exception e) {
			System.out.println("caught something unexpected:");
			e.printStackTrace();
			throw new RuntimeException();
		}
		throw new RuntimeException("illegal monitor state should have been thrown");
	}
	
	public static void main(String[] args) { new SynchronizedCloneTest().run(); }
}
